/*
 * Decompiled with CFR 0.152.
 */
package com.biz.core.zookeeper;

import com.biz.core.zookeeper.ConfigUtils;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.retry.RetryNTimes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZooClient {
    private static final Logger LOG = LoggerFactory.getLogger(ZooClient.class);
    private static CuratorFramework client;

    public static synchronized CuratorFramework getClient() {
        if (client == null) {
            String zookeeperUrl = ZooClient.getZookeeperUrl().replace("zookeeper://", "").replace("?backup=", ",");
            LOG.info("zookeeperUrl: {}", (Object)zookeeperUrl);
            try {
                client = CuratorFrameworkFactory.builder().connectString(zookeeperUrl).retryPolicy((RetryPolicy)new RetryNTimes(Integer.MAX_VALUE, 1000)).connectionTimeoutMs(8000).build();
                client.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return client;
    }

    private static String getZookeeperUrl() {
        String url = ConfigUtils.getZookeeperUrl();
        if (url == null) {
            try {
                url = ConfigUtils.getString("connection/zookeeper.properties", "zookeeper.url");
            }
            catch (Exception ignored) {
                ignored.printStackTrace();
            }
        }
        return url;
    }

    public static void close() {
        if (client != null) {
            client.close();
        }
    }
}

