package com.biz.eisp.activiti.vo;

import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;

public class ActivitiRpcStatus {
    @ActivitiDescription(value = "操作成功", key = 1000)
    public static int SERVER_SUCCESS = 1000;
    @ActivitiDescription(value = "服务器错误", key = 1001)
    public static int SERVER_GENERIC_ERROR = 1001;
    @ActivitiDescription(value = "缺少参数", key = 1002)
    public static int INVALID_REQUEST_PARAMETER = 1002;
    @ActivitiDescription(value = "没查询到对应的工作流", key = 1003)
    public static int FOUNT_NOT_PROCESS = 1003;
    @ActivitiDescription(value = "没查询到对应的表单", key = 1004)
    public static int FOUNT_NOT_FORM = 1004;
    @ActivitiDescription(value = "没查询到对应的表单", key = 1005)
    public static int FOUNT_NOT_POSITION = 1005;
    @ActivitiDescription(value = "表单已经发起过", key = 1006)
    public static int FORM_NO_EXIST = 1006;
    @ActivitiDescription(value = "表单号为空或者没找到相关流程", key = 1007)
    public static int FORM_NULL = 1007;
    @ActivitiDescription(value = "流程已发起，提交到下一步失败", key = 1007)
    public static int TO_NEXT_TASK_FAILED = 1008;

    @ActivitiDescription(value = "角色并未在流程中被使用", key = 2000)
    public static int ROLE_NOT_EXIST = 2000;
    @ActivitiDescription(value = "角色已经在流程中被使用", key = 2001)
    public static int ROLE_EXIST = 2001;

    protected static Map<Integer, String> descriptionMap = new LinkedHashMap<>();

    static {
        Field[] fields = ActivitiRpcStatus.class.getDeclaredFields();

        for (Field field : fields) {
            if (field.isAnnotationPresent(ActivitiDescription.class)) {
                ActivitiDescription description = field.getAnnotation(ActivitiDescription.class);

                descriptionMap.put(description.key(), description.value());
            }
        }
    }

    public static String getDescription(int errorCode) {
        return descriptionMap.get(errorCode);
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
