package com.biz.eisp.activiti.vo;

import java.io.Serializable;

public class ReturnValue implements Serializable {

    /**
     *
     */
    private static final long serialVersionUID = 3758309468353265232L;
    private int               code;
    private String            message;
    private Object            data;

    public ReturnValue() {}

    public ReturnValue(int code) {
        this.code = code;
        this.setMessage(ActivitiRpcStatus.getDescription(code));
    }

    public ReturnValue(Object object) {
        this.data    = object;
        this.code    = ActivitiRpcStatus.SERVER_SUCCESS;
        this.message = ActivitiRpcStatus.getDescription(ActivitiRpcStatus.SERVER_SUCCESS);
    }

    public ReturnValue(int code, String message) {
        this.code    = code;
        this.message = message;
    }

    public ReturnValue(int code, String message, Object object) {
        this.code    = code;
        this.message = message;
        this.data    = object;
    }

    public int getCode() {
        return code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public Object getData() {
        return data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public String getMessage() {
        return message;
    }

    public void setMessage(String message) {
        this.message = message;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
