package com.biz.eisp.activiti.rpc;

import com.biz.eisp.activiti.vo.NoReadMsgsVo;

/**
 * Created by weston on 2017/7/6.
 */
public interface MsgRpcService {
    
	Integer getMyMsgUnReadCount(String userName);
    
	/**
	 * 获得我的未读消息信息
	 * 
	 * @param userName
	 * @return
	 */
    NoReadMsgsVo getMyNoReadMsgsInfo(String userName);
    
    /**
     * 标记所有消息为已读
     * 
     * @param userName
     * @throws Exception
     */
    void dealAllMsgsAsReaded(String userName) throws Exception;
    
    /**
     * 发送消息To流程
     * 
     * @param sendUserName  发送者用户名
     * @param receiveUserName  接收者用户名（非空）
     * @param msgContent  消息内容（非空）
     * @param msgType  消息类型 （非空）{@link com.biz.eisp.activiti.rpc.enums.MsgTypesEnum}
     * @throws RuntimeException
     */
    void sendMsgToAct(String sendUserName, String receiveUserName, 
    		String msgContent, String msgType) throws RuntimeException;
}
