/*
 * Decompiled with CFR 0.152.
 */
package com.chinayanghe.ai.enums;

import java.util.HashMap;
import java.util.Map;

public enum WineType {
    HAIZHILAN("\u6d77\u4e4b\u84dd", 1),
    TIANZHILAN("\u5929\u4e4b\u84dd", 2),
    MENGZHILAN("\u68a6\u4e4b\u84dd", 3);

    private String desc;
    private Integer typeCode;
    private static Map<Integer, String> WINE_TYPE_MAP;

    private WineType(String desc, Integer typeCode) {
        this.desc = desc;
        this.typeCode = typeCode;
    }

    public String getDesc() {
        return this.desc;
    }

    public Integer getTypeCode() {
        return this.typeCode;
    }

    public static String getWineTypeDesc(Integer typeCode) {
        if (WINE_TYPE_MAP == null) {
            WINE_TYPE_MAP = new HashMap<Integer, String>();
            for (WineType wineType : WineType.values()) {
                WINE_TYPE_MAP.put(wineType.getTypeCode(), wineType.getDesc());
            }
        }
        return WINE_TYPE_MAP.get(typeCode);
    }

    static {
        WINE_TYPE_MAP = null;
    }
}

