/*
 * Decompiled with CFR 0.152.
 */
package com.biz.eisp.page;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Page
extends HashMap<String, String> {
    public static String DEFAULT_PAGENAME = "easyui";
    public static String DEFAULT_PAGESIZE = "15";
    public static String DEFAULT_EXPORTSIZE = "60000";
    public static String DEFAULT_PAGE = "1";
    public static String PAGE = "page";
    public static String ROWS = "rows";
    public static String TOTAL = "total";
    public static String SORT = "sort";
    public static String TOTAL_PAGE_COUNT = "totalPageCount";
    public static String DIR = "dir";
    public static String DEFAULT_SORT = "defaultSort";
    public static String USER_ID_KEY = "_userId";
    public static String EMP_ID_KEY = "_empId";
    public static String EMP_SUBCODE_KEY = "_empSubCode";
    public static String EMP_LEVELCODE_KEY = "_empLevelCode";
    public static String PARENT_EMP_ID_KEY = "_parentEmpId";
    public static String PARENT_EMP_SUBCODE_KEY = "_parentEmpSubCode";
    public static String PARENT_EMP_lEVELCODE_KEY = "_parentEmpLevelCode";
    public static String POSITION_ID_KEY = "_empId";
    public static String POSITION_SUBCODE_KEY = "_positionSubCode";
    public static String POSITION_LEVELCODE_KEY = "_positionLevelCode";
    public static String PARENT_POSITION_ID_KEY = "_parentPositionId";
    public static String PARENT_POSITION_SUBCODE_KEY = "_parentPositionSubCode";
    public static String PARENT_POSITION_lEVELCODE_KEY = "_parentPositionLevelCode";
    public static String DEPART_SUBCODE_KEY = "_orgDepartCode";
    public static String DEPART_ID_KEY = "_departId";
    public static String PARENT_DEPART_ID_KEY = "_parentDepartId";
    public static String PARENT_DEPART_SUBCODE_KEY = "_parentDepartSubCode";
    public static String EMP_AUTH_KEY = "_empAuth";
    public static String ORG_SUBCODE_KEY = "_orgSubCode";
    public static String ORG_ID_KEY = "_orgId";
    public static String ORG_AUTH_KEY = "_orgAuth";
    public static String POSITION_AUTH_KEY = "_positionAuth";
    public static String POSITION_CASCADE_AUTH_KEY = "_positionCascadeAuth";
    public static String DEPART_AUTH_KEY = "_departAuth";
    public static String DATA_AUTH = "_dataAuth";
    public static String DATA_AUTH_LEVEL = "_dataAuthLevel";
    public static String AUTH_PREFIX = "_authPrefix";
    protected String pageName;
    protected boolean paging = true;

    public Page() {
        this.pageName = DEFAULT_PAGENAME;
        this.initParams();
    }

    public Page(HttpServletRequest request) {
        this(request, DEFAULT_PAGENAME);
    }

    public Page(HttpServletRequest request, String pageName) {
        this.pageName = pageName;
        this.initParams();
        this.initParams(request);
    }

    public void initParams() {
        this.put(PAGE, DEFAULT_PAGE);
        this.put(ROWS, DEFAULT_PAGESIZE);
    }

    public void setPage(String page) {
        this.put(PAGE, page);
    }

    public void setRows(String rows) {
        this.put(ROWS, rows);
    }

    public void initParams(HttpServletRequest request) {
        request.getSession().removeAttribute(this.pageName);
        if (request.getSession().getAttribute(this.pageName) != null) {
            this.putAll((Map)request.getSession().getAttribute(this.pageName));
        }
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = names.nextElement().toString();
            this.put(name, request.getParameter(name).replaceAll("'", "''"));
        }
        request.getSession().setAttribute(this.pageName, (Object)this);
    }

    public int getPageNo() {
        int page = this.getInt(PAGE);
        int rows = this.getInt(ROWS);
        return (page - 1) * rows;
    }

    public int getInt(String name) {
        return this.get(name) != null ? Integer.parseInt((String)this.get(name)) : 0;
    }

    public long getLong(String name) {
        return this.get(name) != null ? Long.parseLong((String)this.get(name)) : 0L;
    }

    public static void setValue(HttpServletRequest request, String pageName, String name, String value) {
        Map page = (Map)request.getSession().getAttribute(pageName);
        if (page != null) {
            page.put(name, value);
        }
    }

    public static void setValue(HttpServletRequest request, String name, String value) {
        Page.setValue(request, DEFAULT_PAGENAME, name, value);
    }

    public void compute() {
        int pageSize;
        int totalCount = this.getInt(TOTAL);
        this.put(TOTAL_PAGE_COUNT, totalCount % (pageSize = this.getInt(PAGE)) == 0 ? String.valueOf(totalCount / pageSize) : String.valueOf(totalCount / pageSize + 1));
    }

    public static String getValue(HttpServletRequest request, String pageName, String name) {
        Map page = (Map)request.getSession().getAttribute(pageName);
        if (page != null) {
            return (String)page.get(name);
        }
        return null;
    }

    public static String getValue(HttpServletRequest request, String name) {
        return Page.getValue(request, DEFAULT_PAGENAME, name);
    }

    public boolean isPaging() {
        return this.paging;
    }

    public void setPaging(boolean paging) {
        this.paging = paging;
    }
}

