/**
 * 2017 
 * 2017年5月17日  
 * 上午9:34:24
 * ApplyBudgetTitleInVo.java
 * com.chinayanghe.msp.budget.vo.applybudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.applybudget.in;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.applybudget.code.ApplyBudgetCode;
import com.chinayanghe.msp.budget.vo.applybudget.out.ApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 市场活动表单抬头数据
 * @author yangshuo
 *
 */
public class ApplyBudgetTitleInVo extends BaseVo implements ApplyBudgetCode{
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -658765362297757955L;

	/**
	 * 市场活动申请单   必填
	 */
	private String marketActiveNo;
	
	/**
	 * 审批通过日期 必填
	 */
	private Date date;	
	/**
	 * 用户Id 必填
	 */
	private String user;
	
	/**
	 * 用户名字
	 */
	private String userName;
	
	/**
	 * 市场活动表单明细数据（一行到多行）
	 */
	private List<ApplyBudgetDetailInVo> detail;
	@Override
	public BizResponseJson<List<ApplyBudgetOutVo>> validate() {
		if(StringUtils.isBlank(marketActiveNo)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(MARKETACTIVENO_NULL,null,"<市场活动申请单号>为必须字段，不能为空");
		}
 
		if(null == date){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(SUBMMITDATE_NULL,null,"<审批通过日期>为必须字段，不能为空");
		}
 
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		if(CollectionUtils.isEmpty(detail)){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(MARKETACTIVITYDETAIL_NULL,null,"<市场活动表单明细数据>为必须，不能为空");
		}
		//用来判断是否重复
		Set<String> set = new HashSet<String>();
		for(ApplyBudgetDetailInVo vo :detail){
			BizResponseJson<List<ApplyBudgetOutVo>> bizResponseJson = vo.validate();
			if(bizResponseJson.getCode() != BizResponseJson.SC_OK){
				return bizResponseJson;
			}
			set.add(vo.getBrandCategory()+"_"+vo.getChannel()+"_"+vo.getCostType());
		}
		//传入明细的品牌大类+渠道+费用类型有重复
		if(set.size()!=detail.size()){
			return new BizResponseJson<List<ApplyBudgetOutVo>>(DUPLICATE,null,"传入明细的品牌大类+渠道+费用类型有重复");
		}
		//验证成功
		return new BizResponseJson<List<ApplyBudgetOutVo>>();
	}
	public String getMarketActiveNo() {
		return marketActiveNo;
	}
	public void setMarketActiveNo(String marketActiveNo) {
		this.marketActiveNo = marketActiveNo;
	}
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	public String getUser() {
		return user;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public List<ApplyBudgetDetailInVo> getDetail() {
		return detail;
	}
	public void setDetail(List<ApplyBudgetDetailInVo> detail) {
		this.detail = detail;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}

}
