/**
 * 2017 
 * 2017年5月4日  
 * 下午4:04:10
 * BillCauseBranchChannelVo.java
 * com.chinayanghe.msp.budget.vo.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.billcanusebranch.in;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.billcanusebranch.code.BillCanUseBranchCode;
import com.chinayanghe.msp.budget.vo.billcanusebranch.out.BillCanuseBranchChannelOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 取得表单可用列支渠道  Vo   in
 * @author yangshuo
 *
 */
public class BillCanuseBranchChannelInVo extends BaseVo implements BillCanUseBranchCode,Serializable {
 
 
    /**
     * 二级活动类型
     */
    private String secondActiveTypeCode;
    
    /**
     * 费用类型
     */
    private String costType;

    /**
     * 品牌大类
     */
    private String brandCategoryCode;

    /**
     * 分公司
     */
    private String subCompany;

    /**
     * 大区
     */
    private String district;
	/**
     * 日期 年月日
     */
    private Date canuseDate;
    
    /**
     * 经销商
     */
    private String dealer;
 

	public Date getCanuseDate() {
		return canuseDate;
	}

	public void setCanuseDate(Date canuseDate) {
		this.canuseDate = canuseDate;
	}

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -2174375919347203780L;

	@Override
	public BizResponseJson<List<BillCanuseBranchChannelOutVo>> validate() {
		if(StringUtils.isBlank(secondActiveTypeCode)){
			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(SECONDACTIVETYPECODE_NULL, null, "<二级活动类型>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(costType)){
			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(COSTTYPE_NULL, null, "<费用类型>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(brandCategoryCode)){
			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(BRANDCATEGORYCODE_NULL, null, "<品牌大类>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(subCompany)){
			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(SUBCOMPANY_NULL, null, "<分公司>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(district)){
			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(DISTRICT_NULL, null, "<大区>为必须字段，不能为空");
		}
//		if(StringUtils.isBlank(dealer)){
//			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(DEALER_NULL, null, "<经销商>为必须字段，不能为空");
//		}
		if(null==canuseDate){
			return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>(CANUSEDATE_NULL, null, "<日期>为必须字段，不能为空");
		}
		return new BizResponseJson<List<BillCanuseBranchChannelOutVo>>();
	}

	public String getSecondActiveTypeCode() {
		return secondActiveTypeCode;
	}

	public void setSecondActiveTypeCode(String secondActiveTypeCode) {
		this.secondActiveTypeCode = secondActiveTypeCode;
	}

 

	public String getDealer() {
		return dealer;
	}

	public void setDealer(String dealer) {
		this.dealer = dealer;
	}

	public String getCostType() {
		return costType;
	}

	public void setCostType(String costType) {
		this.costType = costType;
	}

	public String getBrandCategoryCode() {
		return brandCategoryCode;
	}

	public void setBrandCategoryCode(String brandCategoryCode) {
		this.brandCategoryCode = brandCategoryCode;
	}

	public String getSubCompany() {
		return subCompany;
	}

	public void setSubCompany(String subCompany) {
		this.subCompany = subCompany;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

}
