/**
 * 2017 
 * 2017年5月9日  
 * 上午9:25:42
 * CheckBudgetInVo.java
 * com.chinayanghe.msp.budget.vo.checkbudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.checkbudget.in;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.checkbudget.code.MarketActiveTitleCode;
import com.chinayanghe.msp.budget.vo.checkbudget.out.CheckBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 市场活动表单抬头数据
 *  QYX_BUD_INTF_0001	申请检查或提交 - 检查预算和冻结预算
 * @author yangshuo
 *
 */
public class MarketActiveTitleInVo extends BaseVo implements MarketActiveTitleCode {

 
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 5234735474633122499L;

	/**
	 * 执行方式  必填
	 */
	private String execType;
	
	/**
	 * 市场活动申请单   必填
	 */
	private String marketActiveNo;
	/**
	 * 预算年度 必填
	 */
	private Short budgetYear;
	/**
	 * 提交审批日期 必填
	 */
	private Date submmitDate;	
	/**
	 * 公司
	 */
	private String company;
	
	/**
	 * 大区
	 */
	private String district;
	/**
	 * 分公司
	 */
	private String subCompany;
	/**
	 * 一级巴
	 */
	private String oneBar;
	/**
	 * 二级巴
	 */
	private String twoBar;
	/**
	 * 一级部门 department
	 */
	private String oneDepartment;
	/**
	 * 二级部门
	 */
	private String twoDepartment;
	/**
	 * 三级部门
	 */
	private String threeDepartment;
	/**
	 * 四级部门
	 */
	private String fourDepartment;
	/**
	 * 五级部门
	 */
	private String fiveDepartment;
	
	/**
	 * 经销商
	 */
	private String franchiserCode;
	
	/**
	 * 列支渠道  必填
	 */
	private String branchChannelCode;
	
	/**
	 * 用户Id 必填
	 */
	private String user;
	
	/**
	 * 用户名字
	 */
	private String userName;
	
	/**
	 * 备注
	 */
	private String remark;
	
	/**
     * 预留维度一
     */
    private String extend1;

    /**
     * 预留维度二
     */
    private String extend2;

    /**
     * 预留维度三
     */
    private String extend3;

    /**
     * 预留维度四
     */
    private String extend4;
    /**
     * 预留维度五
     */
    private String extend5;
	
	/**
	 * 市场活动表单明细数据（一行到多行）
	 */
	private List<MarketActiveDetailInVo> detail;
	
    
    /**
     * 创建这条单据是谁调用的，主要用于过渡阶段SAP调用webservice
     */
    private String fromSource;
	@Override
	public BizResponseJson<List<CheckBudgetOutVo>> validate() {
		if(StringUtils.isBlank(execType)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(EXECTYPE_NULL,null,"<执行方式>为必须字段，不能为空");
		}
		if(!(execType.equals(EXEC_TYPE_CHECK)||execType.equals(EXEC_TYPE_LOCK))){
			return new BizResponseJson<List<CheckBudgetOutVo>>(EXECTYPE_NULL,null,"<执行方式>只能是1或2");
		}
		if(execType.equals(EXEC_TYPE_LOCK) && StringUtils.isBlank(marketActiveNo)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(MARKETACTIVENO_NULL,null,"<市场活动申请单号>为必须字段，不能为空");
		}
		if(null == budgetYear){
			return new BizResponseJson<List<CheckBudgetOutVo>>(BUDGETYEAR_NULL,null,"<预算年度>为必须字段，不能为空");
		}
		if(null == submmitDate){
			return new BizResponseJson<List<CheckBudgetOutVo>>(SUBMMITDATE_NULL,null,"<提交审批日期>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(branchChannelCode)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(BRANCHCHANNELCODE_NULL,null,"<列支渠道>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		if(CollectionUtils.isEmpty(detail)){
			return new BizResponseJson<List<CheckBudgetOutVo>>(MARKETACTIVITYDETAIL_NULL,null,"<市场活动表单明细数据>为必须，不能为空");
		}
		if(StringUtils.isBlank(company)&&StringUtils.isBlank(district)
				&&StringUtils.isBlank(subCompany)&&StringUtils.isBlank(oneBar)
				&&StringUtils.isBlank(twoBar)&&StringUtils.isBlank(oneDepartment)
				&&StringUtils.isBlank(twoDepartment)&&StringUtils.isBlank(threeDepartment)
				&&StringUtils.isBlank(fourDepartment)&&StringUtils.isBlank(fiveDepartment)
				){
			
			return new BizResponseJson<List<CheckBudgetOutVo>>(COMPANY_ALL_NULL,null,"公司，大区，分公司，一级巴，二级巴，一级部门，一级部门，三级部门，四级部门，五级部门不能都为空");
		}
		//用来判断是否重复
		Set<String> set = new HashSet<String>();
		for(MarketActiveDetailInVo vo :detail){
			BizResponseJson<List<CheckBudgetOutVo>> bizResponseJson = vo.validate();
			if(bizResponseJson.getCode() != BizResponseJson.SC_OK){
				return bizResponseJson;
			}
			set.add(vo.getBrandCategory()+"_"+vo.getChannel()+"_"+vo.getCostType());
		}
		//传入明细的品牌大类+渠道+费用类型有重复
		if(set.size()!=detail.size()){
			return new BizResponseJson<List<CheckBudgetOutVo>>(DUPLICATE,null,"传入明细的品牌大类+渠道+费用类型有重复");
		}

		//验证成功
		return new BizResponseJson<List<CheckBudgetOutVo>>();
	}

	public String getExecType() {
		return execType;
	}

	public void setExecType(String execType) {
		this.execType = execType;
	}

	public String getMarketActiveNo() {
		return marketActiveNo;
	}

	public void setMarketActiveNo(String marketActiveNo) {
		this.marketActiveNo = marketActiveNo;
	}

	public Short getBudgetYear() {
		return budgetYear;
	}

	public void setBudgetYear(Short budgetYear) {
		this.budgetYear = budgetYear;
	}

	public Date getSubmmitDate() {
		return submmitDate;
	}

	public void setSubmmitDate(Date submmitDate) {
		this.submmitDate = submmitDate;
	}

	public String getCompany() {
		return company;
	}

	public void setCompany(String company) {
		this.company = company;
	}

	public String getDistrict() {
		return district;
	}

	public void setDistrict(String district) {
		this.district = district;
	}

	public String getSubCompany() {
		return subCompany;
	}

	public void setSubCompany(String subCompany) {
		this.subCompany = subCompany;
	}

	public String getOneBar() {
		return oneBar;
	}

	public void setOneBar(String oneBar) {
		this.oneBar = oneBar;
	}

	public String getTwoBar() {
		return twoBar;
	}

	public void setTwoBar(String twoBar) {
		this.twoBar = twoBar;
	}

	public String getOneDepartment() {
		return oneDepartment;
	}

	public void setOneDepartment(String oneDepartment) {
		this.oneDepartment = oneDepartment;
	}

	public String getTwoDepartment() {
		return twoDepartment;
	}

	public void setTwoDepartment(String twoDepartment) {
		this.twoDepartment = twoDepartment;
	}

	public String getThreeDepartment() {
		return threeDepartment;
	}

	public void setThreeDepartment(String threeDepartment) {
		this.threeDepartment = threeDepartment;
	}

	public String getFourDepartment() {
		return fourDepartment;
	}

	public void setFourDepartment(String fourDepartment) {
		this.fourDepartment = fourDepartment;
	}

	public String getFiveDepartment() {
		return fiveDepartment;
	}

	public void setFiveDepartment(String fiveDepartment) {
		this.fiveDepartment = fiveDepartment;
	}

	public String getFranchiserCode() {
		return franchiserCode;
	}

	public void setFranchiserCode(String franchiserCode) {
		this.franchiserCode = franchiserCode;
	}

	public String getBranchChannelCode() {
		return branchChannelCode;
	}

	public void setBranchChannelCode(String branchChannelCode) {
		this.branchChannelCode = branchChannelCode;
	}

	public String getUser() {
		return user;
	}

	public void setUser(String user) {
		this.user = user;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public List<MarketActiveDetailInVo> getDetail() {
		return detail;
	}

	public void setDetail(List<MarketActiveDetailInVo> detail) {
		this.detail = detail;
	}

	public String getExtend1() {
		return extend1;
	}

	public void setExtend1(String extend1) {
		this.extend1 = extend1;
	}

	public String getExtend2() {
		return extend2;
	}

	public void setExtend2(String extend2) {
		this.extend2 = extend2;
	}

	public String getExtend3() {
		return extend3;
	}

	public void setExtend3(String extend3) {
		this.extend3 = extend3;
	}

	public String getExtend4() {
		return extend4;
	}

	public void setExtend4(String extend4) {
		this.extend4 = extend4;
	}

	public String getExtend5() {
		return extend5;
	}

	public void setExtend5(String extend5) {
		this.extend5 = extend5;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getFromSource() {
		return fromSource;
	}

	public void setFromSource(String fromSource) {
		this.fromSource = fromSource;
	}

 
}
