/**
 * 2017 
 * 2017年5月15日  
 * 上午11:20:31
 * BudgetBillConstant.java
 * com.chinayanghe.msp.budget.constant
 * budget-service
 */
package com.chinayanghe.msp.budget.constant;

/**
 * 预算预留单常量
 * @author yangshuo
 *
 */
public interface BudgetBillConstant {
	
	/**************以下是预算预留单 单据来源****************/	
	/**
	 * 单据来源   1000 – 市场活动申请单
	 */
	String BUDGET_RESOURCE_MARKET_ACTIVITY ="1000";	
	/**
	 * 单据来源	1002 – 预算转移申请单
	 */
	String BUDGET_RESOURCE_TRANSFER_MARKET_ACTIVITY ="1002";
	
	/*************以下是 预算预留单状态*************/
	/**
	 * 预算预留单状态 103 – 审批中
	 */
	String BUDGET_BILL_STATE_ING = "103";
	
	/**
	 * 预算预留单状态 104 – 审批通过
	 */
	String BUDGET_BILL_STATE_SUCCESS = "104";
	
	/**
	 * 预算预留单状态 101 – 作废
	 */
	String BUDGET_BILL_STATE_CANCLE = "101";
	
	/**
	 * 预算预留单状态 105 – 执行中
	 */
	String BUDGET_BILL_STATE_EXEC_ING = "105";
	
	/**
	 * 未使用 关闭 如果原状态是104-审批通过，则状态更改为102-未使用关闭
	 */
	String BUDGET_BILL_STATE_UNUSE_CLOSE = "102";
	/**
	 * 如果原状态是105-执行中，则状态更改为109-关闭
	 */
	String BUDGET_BILL_STATE_CLOSE = "109";


	
	/***************组织裂变常量****************/
	/**
	 * 未发生裂变
	 */
	String ISFISSION_NO = "0";
	/**
	 * 已发生裂变
	 */
	String ISFISSION_YES = "1";
	/****************预算预留单关闭原因*********************/
	/**
	 * 1001 - 申请全部核报关闭
	 */
	String AUDIT_CLOSE = "1001";
	/**
	 * 1000 - 人工关闭
	 */
	String HUMAN_CLOSE = "1000";
	/**
	 * 1002 -预算转移申请审批通过
	 */
	String AUDIT_TRANSFER_CLOSE = "1002";
}
