/**
 * 2017 
 * 2017年5月21日  
 * 下午1:33:48
 * AuditApplyBudgetTitleInVo.java
 * com.chinayanghe.msp.budget.vo.auditapplybudget.in
 * budget-rpc
 */
package com.chinayanghe.msp.budget.vo.auditapplybudget.in;

import com.chinayanghe.msp.budget.vo.auditapplybudget.code.AuditApplyBudgetCode;
import com.chinayanghe.msp.budget.vo.auditapplybudget.out.AuditApplyBudgetOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/**
 * @author yangshuo
 *
 */
public class AuditApplyBudgetTitleInVo extends BaseVo implements AuditApplyBudgetCode {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -6742494668568843678L;
	
	/**
	 * 市场活动核报单号   必填
	 */
	private String marketActiveAuditNo;
	
	/**
	 * 市场活动申请单   必填
	 */
	private String marketActiveNo;
	
	/**
	 * 审核通过日期必填
	 */
	private Date date;	
	/**
	 * 用户Id 必填
	 */
	private String user;
	
	/**
	 * 用户名字
	 */
	private String userName;
	
	/**
	 * 备注	
	 */
	private String remark;

	/**
	 * 入账方式 10 20 30
	 */
	private String iAccountTreat;

	/**
	 * 入账经销商编号
	 */
	private  String iKunnr;
	/**
	 * 业务员编号
	 */
	private  String pernr;
	/**
	 * 业务员描述
	 */
	private  String pernrname;
	/**
	 * 提交表单明细
	 */
	private List<AuditApplyBudgetDetailInVo> detail;
	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<AuditApplyBudgetOutVo>> validate() {
		if(StringUtils.isBlank(marketActiveAuditNo)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(MARKETACTIVENO_AUDIT_NULL,null,"<市场活动核报单号>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(marketActiveNo)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(MARKETACTIVENO_NULL,null,"<市场活动申请单号>为必须字段，不能为空");
		}
 
		if(null == date){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(SUBMMITDATE_NULL,null,"<审批通过日期>为必须字段，不能为空");
		}
 
		if(StringUtils.isBlank(user)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(USER_NULL,null,"<用户>为必须字段，不能为空");
		}
		if(CollectionUtils.isEmpty(detail)){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(MARKETACTIVITYDETAIL_NULL,null,"<市场活动表单明细数据>为必须，不能为空");
		}
		//用来判断是否重复
		Set<String> set = new HashSet<String>();
		for(AuditApplyBudgetDetailInVo vo :detail){
			BizResponseJson<List<AuditApplyBudgetOutVo>> bizResponseJson = vo.validate();
			if(bizResponseJson.getCode() != BizResponseJson.SC_OK){
				return bizResponseJson;
			}
			set.add(vo.getBrandCategory()+"_"+vo.getChannel()+"_"+vo.getCostType());
		}
		//传入明细的品牌大类+渠道+费用类型有重复
		if(set.size()!=detail.size()){
			return new BizResponseJson<List<AuditApplyBudgetOutVo>>(DUPLICATE,null,"传入明细的品牌大类+渠道+费用类型有重复");
		}
		//验证成功
		return new BizResponseJson<List<AuditApplyBudgetOutVo>>();
	}
	public String getMarketActiveAuditNo() {
		return marketActiveAuditNo;
	}
	public void setMarketActiveAuditNo(String marketActiveAuditNo) {
		this.marketActiveAuditNo = marketActiveAuditNo;
	}
	public String getMarketActiveNo() {
		return marketActiveNo;
	}
	public void setMarketActiveNo(String marketActiveNo) {
		this.marketActiveNo = marketActiveNo;
	}
	public Date getDate() {
		return date;
	}
	public void setDate(Date date) {
		this.date = date;
	}
	public String getUser() {
		return user;
	}
	public void setUser(String user) {
		this.user = user;
	}
	public String getRemark() {
		return remark;
	}
	public void setRemark(String remark) {
		this.remark = remark;
	}
	public List<AuditApplyBudgetDetailInVo> getDetail() {
		return detail;
	}
	public void setDetail(List<AuditApplyBudgetDetailInVo> detail) {
		this.detail = detail;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getiAccountTreat() {
		return iAccountTreat;
	}

	public void setiAccountTreat(String iAccountTreat) {
		this.iAccountTreat = iAccountTreat;
	}

	public String getiKunnr() {
		return iKunnr;
	}

	public String getPernr() {
		return pernr;
	}

	public void setPernr(String pernr) {
		this.pernr = pernr;
	}

	public String getPernrname() {
		return pernrname;
	}

	public void setPernrname(String pernrname) {
		this.pernrname = pernrname;
	}

	public void setiKunnr(String iKunnr) {
		this.iKunnr = iKunnr;
	}

}
