/**
 * 
 */
package com.chinayanghe.msp.budget.vo.budegettransferobjectcontrol.in;

import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.budegettransferobjectcontrol.code.BudgetTransferObjectControlCode;
import com.chinayanghe.msp.budget.vo.budegettransferobjectcontrol.out.BudegetTransferObjectControlOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * @author Administrator
 *
 */
public class BudegetTransferObjectControlInVo extends BaseVo implements BudgetTransferObjectControlCode{
	
	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -3126077170190800751L;

	/**
	 * 转出组织类型 必填
	 */
	private String orgTypeOut;
	
	/**
	 * 转出经销商编号
	 */
	private String franchiserCodeOut;

	@Override
	public BizResponseJson<List<BudegetTransferObjectControlOutVo>> validate() {
		if(StringUtils.isBlank(orgTypeOut)){
			return new BizResponseJson<List<BudegetTransferObjectControlOutVo>>(ORGTYPEOUT_NULL, null, "<转出组织类型>为必须字段，不能为空");
		}
		return new BizResponseJson<List<BudegetTransferObjectControlOutVo>>();
	}

	public String getOrgTypeOut() {
		return orgTypeOut;
	}

	public void setOrgTypeOut(String orgTypeOut) {
		this.orgTypeOut = orgTypeOut;
	}

	public String getFranchiserCodeOut() {
		return franchiserCodeOut;
	}

	public void setFranchiserCodeOut(String franchiserCodeOut) {
		this.franchiserCodeOut = franchiserCodeOut;
	}

}
