/**
 * 2017
 * 上午11:15:35
 * 2017年6月6日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.budgetproject.in
 * BudgetProjectInVo.java
 * BudgetProjectInVo
 */
package com.chinayanghe.msp.budget.vo.budgetproject.in;

import java.util.Date;
import java.util.List;

import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.budgetproject.code.BudgetProjectCode;
import com.chinayanghe.msp.budget.vo.budgetproject.out.BudgetProjectOutVo;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * QYX_BUD_INTF_0016	根据组织和经销商获取该组织下的预算维度信息
 * @author yangshuo
 *
 */
public class BudgetProjectInVo extends BaseVo  implements BudgetProjectCode{

	/**
	 * 
	 */
	private static final long serialVersionUID = -3140432182461440808L;
	
    /**
     * 预算年度
     */
    private Short budgetYear;

 
    /**
     * 组织
     */
    private String organizationCode;

    /**
     * 组织类型
     */
    private String organizationType;

    /**
     * 经销商
     */
    private String kunnr;
    
    /**
     * 提交日期
     */
    private Date submitDate;

    /**
	 * 品牌大类
	 */
	private String  brandCode;

    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }

	/* (non-Javadoc)
	 * @see com.chinayanghe.msp.budget.vo.in.BaseVo#validate()
	 */
	@Override
	public BizResponseJson<List<BudgetProjectOutVo>> validate() {
		if(null == budgetYear){
			return new BizResponseJson<List<BudgetProjectOutVo>>(BUDGET_YEAR_NULL, null, "<预算年度>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(organizationCode)){
			return new BizResponseJson<List<BudgetProjectOutVo>>(ORGANIZATION_NULL, null, "<组织>为必须字段，不能为空");
		}
		if(StringUtils.isBlank(organizationType)){
			return new BizResponseJson<List<BudgetProjectOutVo>>(ORGANIZATIONTYPE_NULL, null, "<组织类型>为必须字段，不能为空");
		}
		if(null == submitDate){
			return new BizResponseJson<List<BudgetProjectOutVo>>(DATE_NULL, null, "<提交日期>为必须字段，不能为空");
		}
		return new BizResponseJson<List<BudgetProjectOutVo>>();
	}

	public Short getBudgetYear() {
		return budgetYear;
	}

	public void setBudgetYear(Short budgetYear) {
		this.budgetYear = budgetYear;
	}

	public String getOrganizationCode() {
		return organizationCode;
	}

	public void setOrganizationCode(String organizationCode) {
		this.organizationCode = organizationCode;
	}

	public String getOrganizationType() {
		return organizationType;
	}

	public void setOrganizationType(String organizationType) {
		this.organizationType = organizationType;
	}

	public String getKunnr() {
		return kunnr;
	}

	public void setKunnr(String kunnr) {
		this.kunnr = kunnr;
	}

	public Date getSubmitDate() {
		return submitDate;
	}

	public void setSubmitDate(Date submitDate) {
		this.submitDate = submitDate;
	}

}
