/**
 * 2017
 * 下午8:11:51
 * 2017年5月25日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.front.isusedmoney.in
 * IsUsedMoneyInVo.java
 * IsUsedMoneyInVo
 */
package com.chinayanghe.msp.budget.vo.front.isusedmoney.in;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;

/**
 * 
 * @author yangshuo
 *
 */
public class IsUsedMoneyInVo extends BaseVo  implements Serializable {

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = 6982013320024369278L;

	/**
	 * 下达金额map: key:预算地址code, value:变动金额  
	 */
	private HashMap<String, BigDecimal> isUsedMap;

	/**
	 * 备注
	 */
	private HashMap<String,String> markMap;
	
	/**
	 * 操作人员name
	 */
	private String userName;
	/**
	 * 操作人员id
	 */
	private String userId;

	/**
	 * 预算年度
	 */
	private Short budgetYear;

	@Override
	public BizResponseJson<Object> validate() {
		if(MapUtils.isEmpty(isUsedMap)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目下达金额参数不能为空");
		}
		Set<String> set = isUsedMap.keySet();
		for(String key :set){
			if(StringUtils.isBlank(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目下达金额参数不能为空");
			}
			if(null == isUsedMap.get(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目下达金额参数不能为空");
			}
		}
		if(null == budgetYear){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "预算年度不能为空");
		}
		if(StringUtils.isBlank(userId) && StringUtils.isBlank(userName)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "操作人员信息不能全为空");
		}
		return new BizResponseJson<Object>();
	}

	public HashMap<String, BigDecimal> getIsUsedMap() {
		return isUsedMap;
	}

	public void setIsUsedMap(HashMap<String, BigDecimal> isUsedMap) {
		this.isUsedMap = isUsedMap;
	}

	public String getUserName() {
		return userName;
	}

	public void setUserName(String userName) {
		this.userName = userName;
	}

	public String getUserId() {
		return userId;
	}

	public void setUserId(String userId) {
		this.userId = userId;
	}

	public Short getBudgetYear() {
		return budgetYear;
	}

	public void setBudgetYear(Short budgetYear) {
		this.budgetYear = budgetYear;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public HashMap<String, String> getMarkMap() {
		return markMap;
	}

	public void setMarkMap(HashMap<String, String> markMap) {
		this.markMap = markMap;
	}
}
