/**
 * 2017
 * 下午1:59:08
 * 2017年5月24日
 * budget-rpc
 * com.chinayanghe.msp.budget.vo.front.transferplan.in
 * TransferPlanMoneyInVo.java
 * TransferPlanMoneyInVo
 */
package com.chinayanghe.msp.budget.vo.front.transferplan.in;

import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/**
 *  QYX_BUD_FUN_0027_预算项目计划金额转移_ 
 * @author yangshuo
 *
 */
public class TransferPlanMoneyInVo extends BaseVo implements Serializable{

	/**
	 * serialVersionUID
	 */
	private static final long serialVersionUID = -1202470844522404805L;
	/**
	 * 转入计划金额map: key:预算地址code, value:变动金额  为正数
	 */
	HashMap<String, BigDecimal> transferMapIn;
	
	/**
	 * 转出计划金额map: key:预算地址code, value:变动金额   为正数
	 */
	HashMap<String, BigDecimal> transferMapOut;

	Map<String,String> markMap;
	
	/**
	 * 操作人员name
	 */
	private String userName;
	/**
	 * 操作人员id
	 */
	private String userId;

	/**
	 * 预算年度
	 */
	private Short budgetYear;
	
	/**
	 * 转移原因
	 */
	private String budgetChangeReason;
	
	@Override
	public BizResponseJson<Object> validate() {
		if(MapUtils.isEmpty(transferMapIn)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目转入金额参数不能为空");
		}
		Set<String> set = transferMapIn.keySet();
		//转入总金额
		BigDecimal inMoney = BigDecimal.ZERO;
		for(String key :set){
			if(StringUtils.isBlank(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "转入预算项目地址参数不能为空");
			}
			if(null == transferMapIn.get(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "转入预算项目金额不能为空");
			}
			//金额不能为负数
			if(transferMapIn.get(key).compareTo(BigDecimal.ZERO) < 0){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "转入金额不能为负数");				
			}
			inMoney = transferMapIn.get(key).add(inMoney);
		}
		//转出总金额
		BigDecimal outMoney = BigDecimal.ZERO;
		if(MapUtils.isEmpty(transferMapIn)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "项目转出金额参数不能为空");
		}
		Set<String> setOut = transferMapOut.keySet();
		for(String key :setOut){
			if(StringUtils.isBlank(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "转出预算项目地址参数不能为空");
			}
			if(null == transferMapOut.get(key)){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "转出预算项目金额不能为空");
			}
			//金额不能为负数
			if(transferMapOut.get(key).compareTo(BigDecimal.ZERO) < 0){
				return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "转出金额不能为负数");				
			}
			outMoney = transferMapOut.get(key).add(outMoney);
		}
		//转入传出金额不相等
		if(outMoney.compareTo(inMoney) != 0){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "总转入金额不等于总转出金额");
		}
		//计算预算地址交集 如果有交集 那就说明有某个预算地址 既是转入项目 又是转出项目 则报错
		if(CollectionUtils.isNotEmpty(CollectionUtils.intersection(set, setOut))){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "同一个预算项目，不能同时转入和转出");
		}
		if(null == budgetYear){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "预算年度不能为空");
		}
		if(StringUtils.isBlank(budgetChangeReason)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "变动原因不能为空");
		}
		if(StringUtils.isBlank(userId) && StringUtils.isBlank(userName)){
			return new BizResponseJson<Object>(BizResponseJson.NORMAL_ERROR, null, "操作人员信息不能全为空");
		}
		return new BizResponseJson<Object>();
	}
	public HashMap<String, BigDecimal> getTransferMapIn() {
		return transferMapIn;
	}
	public void setTransferMapIn(HashMap<String, BigDecimal> transferMapIn) {
		this.transferMapIn = transferMapIn;
	}
	public HashMap<String, BigDecimal> getTransferMapOut() {
		return transferMapOut;
	}
	public void setTransferMapOut(HashMap<String, BigDecimal> transferMapOut) {
		this.transferMapOut = transferMapOut;
	}
	public String getUserName() {
		return userName;
	}
	public void setUserName(String userName) {
		this.userName = userName;
	}
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public Short getBudgetYear() {
		return budgetYear;
	}
	public void setBudgetYear(Short budgetYear) {
		this.budgetYear = budgetYear;
	}
	public String getBudgetChangeReason() {
		return budgetChangeReason;
	}
	public void setBudgetChangeReason(String budgetChangeReason) {
		this.budgetChangeReason = budgetChangeReason;
	}

	public static long getSerialVersionUID() {
		return serialVersionUID;
	}

	public Map<String, String> getMarkMap() {
		return markMap;
	}

	public void setMarkMap(Map<String, String> markMap) {
		this.markMap = markMap;
	}
}
