package com.chinayanghe.msp.budget.vo.human;

import com.chinayanghe.msp.budget.vo.human.code.HumanProcessCode;
import com.chinayanghe.msp.budget.vo.in.BaseVo;
import com.chinayanghe.msp.budget.vo.out.BizResponseJson;
import org.apache.commons.lang.StringUtils;

import java.io.Serializable;
import java.util.Date;

/**
 * 人工干预预算预留单 输入参数
 */
public class HumanProcessVoIn  extends BaseVo implements HumanProcessCode,Serializable{
    /**
     * 日期 必填
     */
    private Date date;
    /**
     * 用户Id 必填
     */
    private String user;

    /**
     * 用户名字
     */
    private String userName;

    /**
     * 备注
     */
    private String notice;

    /**
     * 预留单号码 必填
     */
    private String fmkblnr;


    public Date getDate() {
        return date;
    }

    public void setDate(Date date) {
        this.date = date;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getUserName() {
        return userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNotice() {
        return notice;
    }

    public void setNotice(String notice) {
        this.notice = notice;
    }

    public String getFmkblnr() {
        return fmkblnr;
    }

    public void setFmkblnr(String fmkblnr) {
        this.fmkblnr = fmkblnr;
    }

    @Override
    public BizResponseJson<String> validate() {
        if(StringUtils.isBlank(fmkblnr)){
            return new BizResponseJson<String>(BizResponseJson.SC_ERROR,null,"<预算预留单号>为必须字段，不能为空");
        }

        if(null == date){
            return new BizResponseJson<String>(BizResponseJson.SC_ERROR,null,"<日期>为必须字段，不能为空");
        }

        if(StringUtils.isBlank(user)){
            return new BizResponseJson<String>(BizResponseJson.SC_ERROR,null,"<用户>为必须字段，不能为空");
        }
        if(StringUtils.isNotBlank(notice)&&notice.length()>32){
            return new BizResponseJson<String>(BizResponseJson.SC_ERROR,null,"备注字段超长");
        }
        //验证成功
        return new BizResponseJson<String>();
    }

}
