package com.chinayanghe.msp.mdm.tag;

import com.biz.eisp.vo.PositionVo;
import com.chinayanghe.msp.mdm.rpc.autho.MdmEispAuthService;
import com.chinayanghe.msp.mdm.util.AuthoUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.ContextLoader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * eisp主数据配置菜单页面内按钮操作权限验证标签class
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/9/6
 */
public class MdmEispOperationButtonAuthTag extends TagSupport{

    private static final long serialVersionUID = -4271912426417175088L;

    //操作按钮/页面区域编码
    private String operationCodes;

    //无权限时写入值
    private Object noauthValue;

    public void setOperationCodes(String operationCodes) {
        this.operationCodes = operationCodes;
    }

    public void setNoauthValue(Object noauthValue) {
        this.noauthValue = noauthValue;
    }

    @Override
    public int doStartTag() throws JspException {
        boolean hasAuth = false;
        PositionVo position = AuthoUtil.getCurrentPosition();
        if (position!=null&&StringUtils.isNotBlank(operationCodes)){
            String functionId = AuthoUtil.getCurrentFunctionId();
            String requestUri = AuthoUtil.getCurrentRequestUri();
            String referer = AuthoUtil.getReferer();
            if (StringUtils.isNotBlank(referer)){
                String tag = "/";
                referer = referer.contains("clickFunctionId=")?referer.substring(referer.indexOf(tag,referer.indexOf("://")+3),referer.indexOf("clickFunctionId=")-1)
                        :referer.substring(referer.indexOf(tag,referer.indexOf("://")+3));
            }
            MdmEispAuthService mdmEispAuthService = ContextLoader.getCurrentWebApplicationContext().getBean(MdmEispAuthService.class);
            hasAuth = mdmEispAuthService.hasOperationButtonPower(position.getPositionCode(),functionId,requestUri,referer,operationCodes.split(","));
        }
        if(hasAuth){
            return EVAL_BODY_INCLUDE;
        }else if (noauthValue!=null){
            JspWriter writer = this.pageContext.getOut();
            try {
                writer.write(ConvertUtils.convert(noauthValue));
            } catch (IOException e) {
                throw new JspException(e.getMessage());
            }
            return SKIP_BODY;
        }else {
            return SKIP_BODY;
        }
    }
}
