package com.chinayanghe.msp.mdm.tag;

import com.biz.eisp.vo.PositionVo;
import com.chinayanghe.msp.mdm.rpc.autho.MdmEispAuthService;
import com.chinayanghe.msp.mdm.util.AuthoUtil;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.web.context.ContextLoader;

import javax.servlet.jsp.JspException;
import javax.servlet.jsp.JspWriter;
import javax.servlet.jsp.tagext.TagSupport;
import java.io.IOException;

/**
 * eisp主数据配置菜单页面内按钮操作权限验证标签class
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/9/6
 */
public class MdmEispRoleCheckAuthTag extends TagSupport{

    private static final long serialVersionUID = -4271912426417175088L;

    //role code
    private String roleCodes;

    //无权限时写入值
    private Object noauthValue;

    public void setRoleCodes(String roleCodes) {
        this.roleCodes = roleCodes;
    }

    public void setNoauthValue(Object noauthValue) {
        this.noauthValue = noauthValue;
    }

    @Override
    public int doStartTag() throws JspException {
        boolean hasAuth = false;
        PositionVo position = AuthoUtil.getCurrentPosition();
        if (position!=null&& StringUtils.isNotBlank(roleCodes)){
            MdmEispAuthService mdmEispAuthService = ContextLoader.getCurrentWebApplicationContext().getBean(MdmEispAuthService.class);
            hasAuth = mdmEispAuthService.hasRole(position.getPositionCode(),roleCodes.split(","));
        }
        if(hasAuth){
            return EVAL_BODY_INCLUDE;
        }else if (noauthValue!=null){
            JspWriter writer = this.pageContext.getOut();
            try {
                writer.write(ConvertUtils.convert(noauthValue));
            } catch (IOException e) {
                throw new JspException(e.getMessage());
            }
            return SKIP_BODY;
        }else {
            return SKIP_BODY;
        }
    }
}
