package com.chinayanghe.msp.mdm.util;

import com.biz.eisp.rpc.ResourceRpcService;
import com.biz.eisp.vo.PositionVo;
import org.apache.commons.beanutils.ConvertUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.web.context.ContextLoader;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;

/**
 * 权限util
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/9/6
 */
public abstract class AuthoUtil {

    private static ResourceRpcService resourceRpcService = null;

    private static String REQUEST_URI_MAPPING_NAME = "org.springframework.web.servlet.HandlerMapping.pathWithinHandlerMapping";

    /**
     * 获取当前登录人名称
     * @return
     */
    public static String getCurrentUsername(){
        Subject subject = SecurityUtils.getSubject();
        if (subject != null) {
            String principal = (String) subject.getPrincipal();
            if (principal != null) {
                return principal;
            }
        }
        return null;
    }

    /**
     * 获取当前登录人岗位
     * @return
     */
    public static PositionVo getCurrentPosition() {
        String username = getCurrentUsername();
        if (StringUtils.isNotEmpty(username)){
            if (resourceRpcService==null){
                resourceRpcService = ContextLoader.getCurrentWebApplicationContext().getBean(ResourceRpcService.class);
            }
            return resourceRpcService.getCurrPosition(username);
        }
        return null;
    }

    /**
     * 获取请求对象
     * @return
     */
    public static HttpServletRequest getCurrentRequest(){
        RequestAttributes requestAttributes = RequestContextHolder.currentRequestAttributes();
        if (requestAttributes != null) {
            HttpServletRequest request = ((ServletRequestAttributes) requestAttributes).getRequest();
            return request;
        }
        return null;
    }

    /**
     * 获取当前访问路径在mdm-eisp中配置的菜单id
     * @return
     */
    public static String getCurrentFunctionId(){
        HttpServletRequest request = getCurrentRequest();
        if (request==null)
            return null;
        String functionId = request.getParameter("clickFunctionId");
        if (StringUtils.isNotBlank(functionId))
            return functionId;
        String referer = getReferer();
        if (StringUtils.isBlank(referer)||!referer.contains("clickFunctionId"))
            return null;
        String[] splits = referer.split("&");
        for (String str :splits){
            if (str.contains("clickFunctionId=")){
                return str.split("clickFunctionId=")[1];
            }
        }
        return null;
    }

    /**
     * 获取当前请求uri
     * @return
     */
    public static String getCurrentRequestUri(){
        HttpServletRequest request = getCurrentRequest();
        if (request==null)
            return null;
        return ConvertUtils.convert(request.getAttribute(REQUEST_URI_MAPPING_NAME));
    }

    /**
     * 获取当前请求来源
     * @return
     */
    public static String getReferer(){
        HttpServletRequest request = getCurrentRequest();
        if (request==null)
            return null;
        return request.getHeader("Referer");
    }

}
