package com.chinayanghe.msp.mdm.vo.product;

import java.io.Serializable;
import java.util.List;

/**
 * 产品层级基础信息
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/6/26
 */
public class ProductHierarchySimpleVo implements Serializable {

    private static final long serialVersionUID = 8687400553503067340L;

    //产品层级名称
    private String levelName;

    //层级编码
    private String levelCode;

    //层级等级
    private Integer level;

    //子层级
    private List<ProductHierarchySimpleVo> childHierarchies;

    public ProductHierarchySimpleVo() {
    }

    public ProductHierarchySimpleVo(String levelName, String levelCode, Integer level) {
        this.levelName = levelName;
        this.levelCode = levelCode;
        this.level = level;
    }

    public ProductHierarchySimpleVo(String levelName, String levelCode, Integer level, List<ProductHierarchySimpleVo> childHierarchies) {
        this(levelName, levelCode, level);
        this.childHierarchies = childHierarchies;
    }

    public String getLevelName() {
        return levelName;
    }

    public void setLevelName(String levelName) {
        this.levelName = levelName;
    }

    public String getLevelCode() {
        return levelCode;
    }

    public void setLevelCode(String levelCode) {
        this.levelCode = levelCode;
    }

    public Integer getLevel() {
        return level;
    }

    public void setLevel(Integer level) {
        this.level = level;
    }

    public List<ProductHierarchySimpleVo> getChildHierarchies() {
        return childHierarchies;
    }

    public void setChildHierarchies(List<ProductHierarchySimpleVo> childHierarchies) {
        this.childHierarchies = childHierarchies;
    }
}
