package com.chinayanghe.msp.mdm.vo.product;


import java.io.Serializable;
import java.util.Date;
import java.util.List;

/** 产品实体.
 */
public class ProductVo implements Serializable{
	private static final long serialVersionUID = 1L;

	private String id;

	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	/**
	 * 产品层级名称
	 */
	private String productName;

	/**
	 * 产品层级父节点ID
	 */
	private String parentId;
	
	/**
	 * 产品层级编码
	 */
	private String productCode;
	/**
	 * 产品层级
	 */
	private String productLevel;
	/**
	 * 产品属性1
	 */
	private String productAttribute1;
	/**
	 * 产品属性2
	 */
	private String productAttribute2;
	/**
	 * 产品属性3
	 */
	private String productAttribute3;
	/**
	 * 产品属性4
	 */
	private String productAttribute4;
	/**
	 * 备注
	 */
	private String remark;
	/**
	 * 创建时间
	 */
	private Date createDate;
	/**
	 * 创建人
	 */
	private String createName;
	/**
	 * 更新时间
	 */
	private Date updateDate;
	/**
	 * 更新人
	 */
	private String updateName;
	/**
	 * 状态 0启用 1停用
	 */
	private Integer enableStatus;
	/**
	 * 是否叶子节点
	 */
	private Integer isLeaf;
	/**
	 * 产品
	 */
	private ProductVo  product;
	/**
	 * 上级产品
	 */
	private List<ProductVo> tmProductList;
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品名称
	 */
	public String getProductName() {
		return productName;
	}

	public String getParentId() {
		return parentId;
	}

	/**
	 * 方法:取得 com.biz.eisp.mdm.product.entity.TmProductEntity
	 * @return com.biz.eisp.mdm.product.entity.TmProductEntity 父级产品
	 */
	public ProductVo getProduct() {
		return product;
	}
	/**
	 * 方法：取得java.util.List<com.biz.eisp.mdm.product.entity.TmProductEntity>
	 * @return java.util.List<com.biz.eisp.mdm.product.entity.TmProductEntity> 下级产品列表
	 */
	public List<ProductVo> getTmProductList() {
		return tmProductList;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品编码
	 */
	public String getProductCode() {
		return productCode;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品层级
	 */
	public String getProductLevel() {
		return productLevel;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性1
	 */
	public String getProductAttribute1() {
		return productAttribute1;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性2
	 */
	public String getProductAttribute2() {
		return productAttribute2;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性3
	 */
	public String getProductAttribute3() {
		return productAttribute3;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品属性4
	 */
	public String getProductAttribute4() {
		return productAttribute4;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 产品备注
	 */
	public String getRemark() {
		return remark;
	}

	public Date getCreateDate() {
		return createDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 创建人
	 */
	public String getCreateName() {
		return createName;
	}
	/**
	 * 方法:取得java.util.Date
	 * @return java.util.Date 创建时间
	 */
	public Date getUpdateDate() {
		return updateDate;
	}
	/**
	 * 方法:取得java.lang.String
	 * @return java.lang.String 更新人
	 */
	public String getUpdateName() {
		return updateName;
	}
	/**
	 * 方法:取得java.lang.Integer
	 * @return java.lang.Integer 状态
	 */
	public Integer getEnableStatus() {
		return enableStatus;
	}


	public void setProductName(String productName) {
		this.productName = productName;
	}

	public void setParentId(String parentId) {
		this.parentId = parentId;
	}

	public void setTmProductList(List<ProductVo> tmProductList) {
		this.tmProductList = tmProductList;
	}

	public void setProductCode(String productCode) {
		this.productCode = productCode;
	}

	public void setProductLevel(String productLevel) {
		this.productLevel = productLevel;
	}

	public void setProductAttribute1(String productAttribute1) {
		this.productAttribute1 = productAttribute1;
	}

	public void setProductAttribute2(String productAttribute2) {
		this.productAttribute2 = productAttribute2;
	}

	public void setProductAttribute3(String productAttribute3) {
		this.productAttribute3 = productAttribute3;
	}

	public void setProductAttribute4(String productAttribute4) {
		this.productAttribute4 = productAttribute4;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public void setCreateDate(Date createDate) {
		this.createDate = createDate;
	}

	public void setCreateName(String createName) {
		this.createName = createName;
	}

	public void setUpdateDate(Date updateDate) {
		this.updateDate = updateDate;
	}

	public void setUpdateName(String updateName) {
		this.updateName = updateName;
	}

	public void setEnableStatus(Integer enableStatus) {
		this.enableStatus = enableStatus;
	}

	public Integer getIsLeaf() {
		return isLeaf;
	}

	public void setIsLeaf(Integer isLeaf) {
		this.isLeaf = isLeaf;
	}
	
}
