package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by isshu on 2017/5/17.
 */
public enum AuditStatus {

    //A01：新增待审核  A02：新增审核未通过  U01：修改待审核
    // U02：修改审核未通过    D01：停用待审核  D02：停用审核未通过  E01：启用待审核  E02：启用审核未通过
    A01("A01","新增待审核"),A02("A02","新增审核未通过"),U01("U01","修改待审核"),
    U02("U02","修改审核未通过"),D01("D01","停用待审核"),D02("D02","停用审核未通过"),E01("E01","启用待审核"),
    E02("E02","启用审核未通过"),P00("P00","审核通过状态");
    private String code;
    private String desc;

    public static final Map<String,AuditStatus> objMap = new HashMap<>();

    public static AuditStatus getObj(String code){

        if(objMap.isEmpty()){

            AuditStatus[] values = AuditStatus.values();
            for (AuditStatus auditStatus : values
                    ) {

                objMap.put(auditStatus.getCode(),auditStatus);
            }
        }
        return objMap.get(code);
    }

    AuditStatus(String code,String desc){

        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }
}
