package com.chinayanghe.msp.mdm.rpc.productSale;


import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.msp.mdm.vo.productSale.ProductSaleVo;
import java.util.List;

/**
 * 物料信息保存更新
 * @author guof.xi
 * @usage
 * @reviewer
 * @since 2017/4/26
 */
public interface ProductSaleRpcService {

    /**
     * 查询商品信息
     * @param productSale
     * @return
     * @throws Exception
     */
    List<ProductSaleVo> findProductSavleVoList(ProductSaleVo productSale)throws Exception;

    /**
     * 根据产品组查询商品信息
     * @param spartCode
     * @return
     * @throws Exception
     */
    List<ProductSaleVo> getProductSaleListBySpartCode(String spartCode)throws Exception;

    /**
     * 分页查询商品基础信息
     * @param pageable 分页信息 queryCondition key->productSaleCode：商品编码（精确），materielName：商品名称（模糊），productSaleCodeOrName：商品编码及名称（编码精确，名称模糊），spartCode：产品组编码（精确），
     *                 productTypeCode：品类编码（精确，商品层级1），productBrandCode：品牌编码（精确，商品层级2），seriesCode：系列编码（精确，商品层级3），bigLevelCode：大类编码（精确，商品层级4），smallLevelCode：细类编码（精确，商品层级5），
     *                 filterFrozen：是否过滤冻结状态商品（精确，boolean）
     * @return
     */
    Page<ProductSaleVo> findProductSaleVoPage(Pageable pageable);
}
