package com.chinayanghe.msp.mdm.rpc.product;


import com.chinayanghe.msp.mdm.vo.product.ProductHierarchyMinVo;
import com.chinayanghe.msp.mdm.vo.product.ProductHierarchySimpleVo;
import com.chinayanghe.msp.mdm.vo.product.ProductLevelVo;
import com.chinayanghe.msp.mdm.vo.product.ProductVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

import java.util.List;

/**
 * 物料层级保存更新
 * @author guof.xi
 * @usage
 * @reviewer
 * @since 2017/4/26
 */
public interface ProductRpcService {


    /**
     * 根据产品编码查询产品所有层级信息
     * @param productCode
     * @return
     * @throws Exception
     */
    List<ProductVo> findProductInfo(String productCode) throws Exception;

    /**
     * 查询所有商品层级信息（已包含层级父子关系）
     * @return
     */
    List<ProductHierarchySimpleVo> findAllProductHierarchies();

    /**
     * 查询所有商品层级信息
     * @return
     */
    List<ProductLevelVo> findAllProductLevel();
    
    /**
     * 查询出编码7位或4位"20"开头所有产品层级
     * 支持层级名称模糊搜索
     * @param productLevelName
     * @return
     */
    Page<ProductHierarchyMinVo> findProductHierarchieByName(String productLevelName,Pageable pageable);

    /**
     * 根据大类名称或者编码模糊查询大类
     * @param productLevel
     * @return
     */
    List<ProductVo> findByProductLevelNameOrLevelCode(String productLevel);
}
