package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by isshu on 2017/8/1.
 * 流程类型
 */
public enum SfaProcessType {

    FX_ZDXZ(1,"终端新增流程","redirect:tmTerminalController.do?saveTmTerminal","/eisp-mdm/tmTerminalController.do?goTmTerminal&optype=1&"+FormReqSource.class.getSimpleName()+"="+FormReqSource.comeFromActivity),
    FX_ZDXG(2,"终端修改审批流程","redirect:tmTerminalController.do?saveTmTerminal","/eisp-mdm/tmTerminalController.do?goTmTerminal&optype=1&"+FormReqSource.class.getSimpleName()+"="+FormReqSource.comeFromActivity),
    //启停用必须分开才能明确
    FX_ZDQ(3,"终端启用审批流程","","/eisp-mdm/tmTerminalController.do?goTmTerminal&optype=1&"+FormReqSource.class.getSimpleName()+"="+FormReqSource.comeFromActivity),
	FX_ZDT(4, "终端停用审批流程", "","/eisp-mdm/tmTerminalController.do?goTmTerminal&optype=1&"+FormReqSource.class.getSimpleName()+"="+FormReqSource.comeFromActivity),
    FX_DCGL(5, "督查报告审批流程", "redirect:/inspectReport/updateInspectDetail",""),
	FX_RYRZ(6, "第三方人员入职审批流程", "redirect:thirdPartyUserController.do?updateFormData",""),
    FX_RYDD(7, "第三方人员调动审批流程", "redirect:thirdPartyUserController.do?updateFormData",""),
	FX_RYLZ(8, "第三方人员离职审批流程", "redirect:thirdPartyUserController.do?updateFormData",""),
    FX_CXRZ(9, "第三方人员重新入职审批流程", "redirect:thirdPartyUserController.do?updateFormData",""),
    FX_SHTZD(10, "收货单审批流程", "redirect:goodsReceipt/updateFormData",""),
    FX_ZZXZ(11,"阿米巴新增审批流程","redirect:yhAmibaController.do?updateInActivity","/eisp-mdm/yhAmibaController.do?goAddOrEditApply"),
    FX_ZZXG(12,"阿米巴修改审批流程","redirect:yhAmibaController.do?updateInActivity","/eisp-mdm/yhAmibaController.do?goAddOrEditApply"),
    FX_ZZDJ(13,"阿米巴冻结审批流程","","/eisp-mdm/yhAmibaController.do?goAddOrEditApply"),
    FX_GWXZ(14,"岗位新增审批流程","redirect:thirdPartyPostController.do?updateFormData",""),
    FX_GWQY(15,"岗位区域变更审批流程","redirect:thirdPartyPostController.do?updateFormData",""),
	FX_RYZCP(16,"转厂聘申请","redirect:thirdPartyUserController.do?updateFormData",""),
	FX_CHGL(17,"窜货申请","redirect:/fleeingGoods/updateForActivity",""),
    FX_DJJMWL(20,"打击假冒伪劣审批流程","redirect:/fakeshoddy/updateFormData","");
    //注意每个枚举单排写，便于冲突处理，处理冲突时，code千万不能相同

    public static final Map<Integer,SfaProcessType> objs = new HashMap<>();
    public static SfaProcessType getObj(int code){

        if(objs.isEmpty()){

            SfaProcessType[] values = SfaProcessType.values();
            for (SfaProcessType v : values
                 ) {

                objs.put(v.getCode(),v);
            }
        }

        return objs.get(code);
    }

    private String desc;
    private int code;
    private String redirect;
    private String formUrl;
    SfaProcessType(int code, String desc, String redirect, String formUrl){

        this.code = code;
        this.desc = desc;
        this.redirect = redirect;
        this.formUrl = formUrl;
    }

    public String getDesc() {
        return desc;
    }

    public int getCode() {
        return code;
    }

    public String getRedirect() {
        return redirect;
    }

    public String getFormUrl() {
        return formUrl;
    }
}
