package com.chinayanghe.msp.mdm.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * Created by isshu on 2017/6/14.
 * 终端类型
 */
public enum TerminalType {

    TYPE_A("10","A类"),

    TYPE_B("11","B类"),

    TYPE_C("12","C类");

    private String code;
    private String desc;

    private static final Map<String,TerminalType> objMap = new HashMap<>();

    public static TerminalType getObj(String code){

        if(objMap.isEmpty()){

            TerminalType[] values = TerminalType.values();
            for (TerminalType terminalType : values
                    ) {

                objMap.put(terminalType.getCode(),terminalType);
            }
        }
        return objMap.get(code);
    }

    TerminalType(String code, String desc){

        this.code = code;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public void setDesc(String desc) {
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }
}
