package com.chinayanghe.msp.mdm.rpc.eslog;

import com.chinayanghe.msp.mdm.vo.eslog.BaseESVersionVo;

import java.util.List;

/**
 * 通用数据版本记录
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/9/11
 */
public interface CommonDataESVersionRpcService {

    /**
     * 增加数据版本
     * @param versionVo
     */
    void addDataVersion(BaseESVersionVo versionVo);

    /**
     * 删除数据版本
     * @param className 类名称
     * @param id 数据id
     * @param versions 数据版本号（无指定删除所有）
     */
    void removeDataVersion(String className,String id,Long... versions);

    /**
     * 查找数据版本（以版本号高到低排序）
     * @param className 类名称
     * @param id 数据id
     * @param versions 指定版本号（无指定查询所有）
     * @return
     */
    List<BaseESVersionVo> findDataVersions(String className,String id,Long... versions);

    /**
     * 查找最新一条版本
     * @param className 类名称
     * @param id 数据id
     * @return
     */
    BaseESVersionVo findLastVersionData(String className,String id);

    /**
     * 查找存在特殊字符串的版本信息
     * @param className 类名称
     * @param id 数据id
     * @param specialInfo 特殊信息
     * @return
     */
    List<BaseESVersionVo> findExistSpecialInfoDataVersion(String className,String id,String specialInfo );
}
