package com.chinayanghe.msp.mdm.vo.eslog;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;

/**
 * entity版本信息 es索引
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2017/9/11
 */
public class BaseESVersionVo implements Serializable{

    private static final long serialVersionUID = 1259979172487643568L;

    //id
    private String id;

    //版本号
    private Long version;

    //版本时间
    private Date versionTime;

    //类名称
    private String className;

    //类数据
    private String entityJsonData;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Long getVersion() {
        return version;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Date getVersionTime() {
        return versionTime;
    }

    public void setVersionTime(Date versionTime) {
        this.versionTime = versionTime;
    }

    public String getClassName() {
        return className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getEntityJsonData() {
        return entityJsonData;
    }

    public void setEntityJsonData(String entityJsonData) {
        this.entityJsonData = entityJsonData;
    }

    public BaseESVersionVo buildDefaultVersion(){
        this.version = Long.valueOf(new SimpleDateFormat("yyyyMMddHHmmssS").format(new Date()));
        return this;
    }

    public BaseESVersionVo buildDefaultVersionTime(){
        this.versionTime = new Date();
        return this;
    }

}
