package com.biz.sfa.rpc;

import com.biz.sfa.vo.req.ActivityDistrubutRpcReqVo;
import com.biz.sfa.vo.req.ActivityRegisterRpcReqVo;
import com.biz.sfa.vo.resp.DistributionPositionRpcRespVo;
import com.biz.sfa.vo.resp.EvidenceInfoRpcRespVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

/**
* @author zhangqiang:
* @version 创建时间：2017年6月26日 下午3:04:01
* 活动取证Service
*/
public interface ActivityEvidenceRpcService  {
	/**
	 * 活动分配信息接收
	 * @param reqVo
	 */
	void activityDistribut(ActivityDistrubutRpcReqVo reqVo);

	/**
	 * 活动登记-获取可分配的岗位人员信息（按标题和门店都用）
	 * 与当前岗位同一个分公司下的所有岗位人员和与分公司有对应关系的经销商人员的岗位，且在当前登记单下还未分配的岗位；
	 * @param reqVo
	 * @return
	 */
	Page<DistributionPositionRpcRespVo> findCanDistributionPosition(ActivityRegisterRpcReqVo reqVo,Pageable pageable);
	
	/**
	 * 根据单号 、行项目号获取取证详情
	 * 输入行项目号获取当前登记单某一行的取证材料，
	 * 不输入表示获取该登记单的所有行项目的取证材料
	 * @param reqVo
	 * @return
	 */
	Page<EvidenceInfoRpcRespVo> getEvidenceInfoByformNo(ActivityRegisterRpcReqVo reqVo, Pageable pageable);
	
	/**
	 * 根据单号 、行项目号获取取证详情
	 * 
	 * @param reqVo
	 * @return
	 */
	EvidenceInfoRpcRespVo getEvidenceInfoByItemNo(ActivityRegisterRpcReqVo reqVo);
}
