package com.biz.sfa.enums;

/**
 * @describe：活动类型枚举
 * @author: zzy
 * @version:v1.0
 * Created by Administrator on 2017/7/13.
 */
public enum ActivityStyleEnum {
    SPECIAL_COLLABORATION(1,"专项合作"),
    FEATURE_PROGRAMS(2,"专题节目植入/定制"),
    CATERING_1(3,"活动定制"),
    CONTENT_CUSTOMIZATION(4,"内容定制"),
    PARIMETIME(5,"时段广告"),
    BUILD_INTO(6,"内容植入"),
    SOFT_RELEASED(7,"软文发布/软植入"),
    CLIENT(8,"客户端/公众号头条"),
    CATERING_2(9,"活动定制"),
    CATERING_3(10,"活动专题定制"),
    DSP_SPREAD(11,"DSP传播"),
    SOCIAL(12,"社会化传播"),
    VIDEO_CHIP(36,"视频前贴片"),
    POLITICAL_CLASS(13,"政经类"),
    STYLE(14,"文体类"),
    CONCERT(15,"演唱会类"),
    PUBLIC(16,"公益赞助类"),
    SPAMMING(17,"刷屏媒体"),
    FLAG_1(18,"灯箱媒体"),
    TRIN(19,"列车广告"),
    BUS_OUT(20,"公交车车身"),
    BUS_IN(21,"公交车车内"),
    BRIDGE(22,"跨线桥"),
    ARTILLERY(23,"高炮"),
    TOLL_STATION(24,"收费站媒体"),
    CITY_LED(25,"城市LED大屏"),
    FLOOR_LCD(26,"楼宇框架/LCD"),
    COMMUNITY(27,"社区媒体"),
    CITY_OUTDOOR(28,"城市户外大牌"),
    FLAG_2(29,"道路灯箱/灯杆旗"),
    DOOR(30,"门头牌"),
    EXCLUSIVE_SHOP(31,"专卖店"),
    DRAMA(32,"剧情植入"),
    CINEMA_1(33,"院线贴片"),
    CINEMA_2(34,"影厅/院冠名"),
    ROOM_IN(35,"厅内展示"),
    WALL_ADVERTISING(37,"墙体广告");

    private int value;
    private String name;

    ActivityStyleEnum(int value, String name) {
        this.value = value;
        this.name = name;
    }

    /**
     * 根据名称查询枚举name
     * @param name
     * @return 不存在返回null
     */
    public static ActivityStyleEnum byName(String name) {
        for (ActivityStyleEnum e : ActivityStyleEnum.values()) {
            if (e.getName().equals(name)) {
                return e;
            }
        }
        return null;
    }

    public int getValue() {
        return value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }
}
