package com.biz.sfa.rpc;

import java.util.List;

import com.biz.sfa.vo.req.ActivityDistrubutRpcReqVo;
import com.biz.sfa.vo.req.ActivityRegisterRpcReqVo;
import com.biz.sfa.vo.req.evidence.EvidenceInfoRpcReqVo;
import com.biz.sfa.vo.req.evidence.EvidenceTransformRpcReqVo;
import com.biz.sfa.vo.req.evidencePhoto.EvidencePhotoCheckReqVo;
import com.biz.sfa.vo.resp.DistributionPositionRpcRespVo;
import com.biz.sfa.vo.resp.EvidenceInfoRpcRespVo;
import com.biz.sfa.vo.resp.evidencePhoto.EvidencePhotoAIPredictRespVo;
import com.biz.sfa.vo.resp.evidencePhoto.EvidencePhotoResultRespVo;
import com.biz.sfa.vo.resp.evidencePhoto.FeastScanCodeRpcRespVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;

/**
* @author zhangqiang:
* @version 创建时间：2017年6月26日 下午3:04:01
* 活动取证Service
*/
public interface ActivityEvidenceRpcService  {
	/**
	 * 活动分配信息接收
	 * @param reqVo
	 */
	void activityDistribut(ActivityDistrubutRpcReqVo reqVo);

	/**
	 * 活动登记-获取可分配的岗位人员信息（按标题和门店都用）
	 * 与当前岗位同一个分公司下的所有岗位人员和与分公司有对应关系的经销商人员的岗位，且在当前登记单下还未分配的岗位；
	 * @param reqVo
	 * @return
	 */
	Page<DistributionPositionRpcRespVo> findCanDistributionPosition(ActivityRegisterRpcReqVo reqVo,Pageable pageable);
	
	/**
	 * 根据单号 、行项目号获取取证详情
	 * 输入行项目号获取当前登记单某一行的取证材料，
	 * 不输入表示获取该登记单的所有行项目的取证材料
	 * @param reqVo
	 * @return
	 */
	@Deprecated
	Page<EvidenceInfoRpcRespVo> getEvidenceInfoByformNo(ActivityRegisterRpcReqVo reqVo, Pageable pageable);
	
	/**
	 * 根据单号 、行项目号获取取证详情
	 * 
	 * @param reqVo
	 * @return
	 */
	EvidenceInfoRpcRespVo getEvidenceInfoByItemNo(ActivityRegisterRpcReqVo reqVo);

	/**
	 * PC端活动取证 详情接收
	 * 
	 * @param reqVo
	 */
	void receiveEvidencePCPhoto(EvidenceInfoRpcReqVo reqVo);
	
	/**
	 * 临时报备单转登记单
	 * @param reqVo
	 */
	void evidenceFormTransform(EvidenceTransformRpcReqVo reqVo);
	
	/**
	 * 根据照片类型判断 是否完成全部的类型取证
	 * @param reqVo
	 * @return
	 */
	EvidencePhotoResultRespVo checkEvidencePhoto(List<EvidencePhotoCheckReqVo> reqVo);

	/**
	 * 取消活动取证
	 * @param formNo
	 */
	void cancelEvidence(String formNo);
	
	/**
	 * 获取家宴照片及拍摄视频信息
	 * @param formNo
	 * @return
	 */
	List<FeastScanCodeRpcRespVo> getFeastEvicendeInfoByFormNo(String formNo,String itemNo);

	/**
	 * 完全核报更改状态
	 * @param formNo 单号
	 */
	void updateActivityStatus(String formNo);

	/**
	 * 查找家宴ai识别结果
	 * 单号集合&行项目号必传一
	 * @param formNos 单号集合
	 * @param itemNos 行项目号（id）集合
	 * @return
	 */
	List<EvidencePhotoAIPredictRespVo> findEvidencePhotoAIPredict(Iterable<String> formNos,Iterable<String> itemNos);
}
