package com.biz.sfa.vo.resp.evidencePhoto;

import com.biz.sfa.enums.EvidenceResourceFileType;
import com.chinayanghe.ai.vo.DisplayBanquetVo;
import com.chinayanghe.ai.vo.PanoramaPhotoVo;

import java.io.Serializable;
import java.util.Date;

/**
 * 家宴ai识别结果
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2018/1/10
 */
public class EvidencePhotoAIPredictRespVo implements Serializable {

    private static final long serialVersionUID = 6814159837466142825L;

    /**
     * 照片视频路径
     */
    private String resourceUrl;

    /**
     * 资源类型
     * {@link com.biz.sfa.enums.EvidenceResourceFileType#code}
     */
    private EvidenceResourceFileType resourceType;

    /**
     * 拍照时间
     */
    private Date createDate;

    /**
     * 登记表单号
     */
    private String formNo;

    /**
     * 行项目号id
     */
    private String itemId;

    /**
     * 家宴照片ai人头识别结果
     * 当resourceType={@link com.biz.sfa.enums.EvidenceResourceFileType#SCENE_PHOTO} 时有此值
     */
    private DisplayBanquetVo banquetVo;

    /**
     * 家宴视频全景拼接及拼接图ai人头识别结果
     * 当resourceType={@link com.biz.sfa.enums.EvidenceResourceFileType#VIDEO_FILE} 时有此值
     */
    private PanoramaPhotoVo panoramaVo;

    public String getResourceUrl() {
        return resourceUrl;
    }

    public void setResourceUrl(String resourceUrl) {
        this.resourceUrl = resourceUrl;
    }

    public EvidenceResourceFileType getResourceType() {
        return resourceType;
    }

    public void setResourceType(EvidenceResourceFileType resourceType) {
        this.resourceType = resourceType;
    }

    public Date getCreateDate() {
        return createDate;
    }

    public void setCreateDate(Date createDate) {
        this.createDate = createDate;
    }

    public String getFormNo() {
        return formNo;
    }

    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    public String getItemId() {
        return itemId;
    }

    public void setItemId(String itemId) {
        this.itemId = itemId;
    }

    public DisplayBanquetVo getBanquetVo() {
        return banquetVo;
    }

    public void setBanquetVo(DisplayBanquetVo banquetVo) {
        this.banquetVo = banquetVo;
    }

    public PanoramaPhotoVo getPanoramaVo() {
        return panoramaVo;
    }

    public void setPanoramaVo(PanoramaPhotoVo panoramaVo) {
        this.panoramaVo = panoramaVo;
    }
}
