package com.biz.sfa.enums;

import java.util.HashMap;
import java.util.Map;

/**
 * @author bruce.qin
 * @usage
 * @reviewer
 * @since 2018/1/9
 */
public enum EvidenceResourceFileType {

    SCENE_PHOTO("0001","现场照片"),
    AGENT_ADVANCE_PROVE("0002","代垫证明"),
    RECEIVABLES_PROVE("0003","收款证明"),
    CONTRACT("0004","合同或协议"),
    CHECKLIST("0005","检查表"),
    ACCEPTANCE_CHECK_LIST("0006","验收表"),
    QUOTATION("0007","报价单"),
    ACCOUNT_STATEMENT("0009","对账单"),
    ATTENDANCE_LIST("0011","考勤表"),
    PAYOFF_TABLE("0012","工资"),
    USER_DETAIL_LIST("0013","使用情况一览表"),
    ADVERTISEMENT_REGISTER_CERTIFICATE("0014","户外广告登记证或承诺函"),
    BANQUET_CERTIFICATE("0017","家宴性质证明材料"),
    OTHER("0019","其他"),
    RECEIPT_OR_INVOICE("0021","收据或发票"),
    RECEIPT("0022","收据"),
    INVOICE("0023","发票"),
    DINNER_AND_HOTEL_INVOICE("0024","用餐及住宿发票"),
    DINNER_SURE_MENU("0025","用餐确认单"),
    SCENIC_SPOT_TICKET("0026","旅游景点门票"),
    TRAFFIC_INVOICE("0027","交通工具发票或收据"),
    MANUFACTURE_DETAIL("0028","制作明细"),
    GRANT_DETAIL("0029","发放明细"),
    REMITTANCE_VOUCHER("0030","汇款凭证"),
    TERMINAL_EXHIBIT_PHOTO("0031","终端陈列照（团购单位除外）"),
    VIDEO_FILE("9999","视频文件")
    ;

    private String code;

    private String desc;

    EvidenceResourceFileType(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public String getCode() {
        return code;
    }

    public String getDesc() {
        return desc;
    }

    private static final Map<String,EvidenceResourceFileType> EVIDENCE_FILE_TYPE_MAP = new HashMap<>();

    /**
     * 根据code获取文件类型
     * @param code
     * @return
     */
    public static EvidenceResourceFileType getEvidenceResourceFileType(String code){
        if (EVIDENCE_FILE_TYPE_MAP.isEmpty()){
            for (EvidenceResourceFileType fileType:EvidenceResourceFileType.values())
                EVIDENCE_FILE_TYPE_MAP.put(fileType.getCode(),fileType);
        }
        return EVIDENCE_FILE_TYPE_MAP.get(code);
    }
}
