package com.biz.sfa.rpc;

import java.util.List;
import java.util.Map;

import com.biz.sfa.vo.activity.SfaActivityApplyVo;
import com.biz.sfa.vo.req.InspectDetailRpcReqVo;
import com.biz.sfa.vo.resp.InspectDetailResultRpcRespVo;

/**
 * @author zhangqiang:
 * @version 创建时间：2017年8月4日 下午7:36:11 督查结果
 */
public interface InspectDetailRpcService {

	/**
	 * 根据formNo、itemNo查询执行结果
	 * 
	 * @param reqVo
	 * @return
	 */
	List<InspectDetailResultRpcRespVo> getExeResultByInspectDetail(InspectDetailRpcReqVo reqVo);
	
	/**
	 * 批量获取 是否督察
	 * @param reqList
	 * @return key 为行项目号 value 为是否标识（0为无1为有）
	 */
	Map<String, Integer> getExeResultByInspectDetailFlag(List<InspectDetailRpcReqVo> reqList);

	/**
	 * 用于督查报告发起流程审批
	 * 
	 * @param terminalAuditApplyVo
	 */
	void launchInspectReportProcess(SfaActivityApplyVo terminalAuditApplyVo);

}
