package com.biz.sfa.rpc.media;

import com.biz.sfa.vo.resp.ExhibitPhotoAndVideoCollectRespVo;
import com.biz.sfa.vo.resp.ExhibitPhotoAndVideoWinePredictRespVo;
import com.biz.sfa.vo.req.Pair;
import com.biz.sfa.vo.resp.TerminalExhibitPhotosRpcRespVo;
import com.chinayanghe.msp.mdm.vo.terminal.resp.TmTerminalRespVo;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface VisitRecordRpcService {

    /**
     * 清除岗位未开始的终端拜访
     * @param positionTerminalCodesMap
     */
    void cleanPositionNotBeginTerminalVisitPlan(Map<String,List<String>> positionTerminalCodesMap);

    /**
     * 照片墙详情
     * @param terminalCode  终端编码
     * @return
     */
    Map<String,List<Object>> queryPhoneWallByTerminalCode(String terminalCode);

    /**
     * 按分公司查询拜访照片墙信息
     * @param terminalCode 终端编码
     * @param filialeCode 分公司编码
     * @return {@link Pair} key:终端基础信息，value:拜访陈列拍摄信息
     */
    Map<String,List<?>> queryPhoneWallByTerminalCode(String terminalCode,String filialeCode);

    /**
     * 查询终端陈列拍摄
     * @param terminalCode
     * @param startDate
     * @param endDate
     * @return
     */
    List<ExhibitPhotoAndVideoCollectRespVo> findExhibitPhotoAndVideo(String terminalCode, Date startDate,Date endDate,String filialeCode);

    /**
     * 批量查询终端陈列拍摄
     * @param terminalCodes 终端编码集合
     * @return key-终端编码
     */
    Map<String,List<ExhibitPhotoAndVideoCollectRespVo>> findExhibitPhotoAndVideoBatch(Iterable<String> terminalCodes,String filialeCode);

    /**
     * 批量查询终端陈列拍摄
     * @param terminalCodes 终端编码集合
     * @return key-终端编码
     */
    Map<String,List<ExhibitPhotoAndVideoCollectRespVo>> findExhibitPhotoAndVideoBatch(Iterable<String> terminalCodes, Date startDate,Date endDate,String filialeCode);

    /**
     * 查找终端拜访时间
     * @param terminalCodes
     * @return
     */
    Map<String,List<Date>> findTerminalVisitDate(Iterable<String> terminalCodes);

    /**
     * 查找终端拜访时间
     * @param terminalCodes
     * @return
     */
    Map<String,List<Date>> findTerminalVisitDate(Iterable<String> terminalCodes, Date startDate,Date endDate);

    /**
     * 批量查询终端陈列拍摄及ai陈列识别
     * @param terminalCodes 终端编码集合
     * @return key-终端编码
     */
    Map<String,List<ExhibitPhotoAndVideoWinePredictRespVo>> findExhibitPhotoAndVideoAndWinePredictBatch(Iterable<String> terminalCodes,String filialeCode);

    /**
     * 批量查询终端陈列拍摄ai陈列识别
     * @param terminalCodes 终端编码集合
     * @return key-终端编码
     */
    Map<String,List<ExhibitPhotoAndVideoWinePredictRespVo>> findExhibitPhotoAndVideoAndWinePredictBatch(Iterable<String> terminalCodes, Date startDate, Date endDate,String filialeCode);

    /**
     * 批量查询终端陈列拍摄
     * @param terminalCodeAndStartEndDates map->key 终端编码，value-> pair: left startDate,right endDate
     * @return key-终端编码
     */
    Map<String,List<ExhibitPhotoAndVideoCollectRespVo>> findExhibitPhotoAndVideoBatch(Map<String,Pair<Date,Date>> terminalCodeAndStartEndDates,String filialeCode);

    /**
     * 批量查询终端陈列拍摄ai陈列识别
     * @param terminalCodeAndStartEndDates map->key 终端编码，value-> pair: left startDate,right endDate
     * @return key-终端编码
     */
    Map<String,List<ExhibitPhotoAndVideoWinePredictRespVo>> findExhibitPhotoAndVideoAndWinePredictBatch(Map<String,Pair<Date,Date>> terminalCodeAndStartEndDates,String filialeCode);

}
