package com.chinayanghe.tpm.cost.vo;

import com.biz.eisp.vo.OrgVo;
import com.biz.eisp.vo.PositionVo;
import com.biz.eisp.vo.UserInfoVo;
import com.chinayanghe.tpm.cost.ApplyFormStatusEnum;
import com.chinayanghe.tpm.cost.dto.*;

import java.util.List;

/**
 * 该模板只适用于 页面的数据传入 转成相应的数据设置
 * @ClassName: com.chinayanghe.tpm.cost.vo.swagger
 * Created by OmarZhang on 2017/5/21 12:50.
 */
public class TemplateTransforVo<T, E> {

    /** 管理信息Dto */
    private ManageInfoDto manageInfoDto;

    /** 活动信息Dto */
    private ActivityBaseInfoDto activityBaseInfoDto;

    /** 财务信息Dto */
    private FinanceInfoApplyDto financeInfoApplyDto;

    /** 促销信息Dto */
    private PromotionInfoDto promotionInfoDto;

    /** 区域市场 */
    private List<AreaMarketingDto> areaMarketingDtos;

    /** 销量控制 */
    private List<SaleLimitDto> saleLimitDtos;

    /** 传输信息 自定义 */
    private T transforDto;

    /** 传输信息 自定义 */
    private E transforDto1;

    /** 职位Vo */
    private PositionVo positionVo;

    /** 当前用户名 */
    private String currentName;

    /** 当前操作用户信息 */
    private UserInfoVo userInfoVo;

    /** 当前所属组织信息Vo (大区/分公司/xxx ) 大区*/
    private OrgVo orgVo;

    /** 分公司*/
    private OrgVo departMentVo;

    /** 组织1 */
    private OrgVo orgVo1;

    /** 组织2 */
    private OrgVo orgVo2;

    /** 组织3 */
    private OrgVo orgVo3;

    /** 组织4 */
    private OrgVo orgVo4;

    /** 表单编号 */
    private String formNo;

    /** 表单类型 */
    private String formType;

    /** 表单状态 */
    private String formStatus;
    /** 表单状态枚举*/
    private ApplyFormStatusEnum formStatusEnum;
    /** 应用工程名称*/
    private String contextName;

    public TemplateTransforVo() {}

    /**
     *
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param transforDto 传输信息
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              T transforDto) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.transforDto         = transforDto;
    }

    /**
     *
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param areaMarketingDtos 市场区域
     * @param transforDto 传输信息
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              List<AreaMarketingDto> areaMarketingDtos, T transforDto) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.areaMarketingDtos   = areaMarketingDtos;
        this.transforDto         = transforDto;
    }

    /**
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param transforDto 传输信息
     * @param transforDto1 传输信息2
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              T transforDto, E transforDto1) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.transforDto         = transforDto;
        this.transforDto1        = transforDto1;
    }

    /**
     *
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param saleLimitDtos 销量控制信息
     * @param areaMarketingDtos 市场区域
     * @param transforDto 传输信息
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              List<SaleLimitDto> saleLimitDtos, List<AreaMarketingDto> areaMarketingDtos,
                              T transforDto) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.areaMarketingDtos   = areaMarketingDtos;
        this.saleLimitDtos       = saleLimitDtos;
        this.transforDto         = transforDto;
    }

    /** 获取 活动信息Dto */
    public ActivityBaseInfoDto getActivityBaseInfoDto() {
        return this.activityBaseInfoDto;
    }

    /** 设置 活动信息Dto */
    public void setActivityBaseInfoDto(ActivityBaseInfoDto activityBaseInfoDto) {
        this.activityBaseInfoDto = activityBaseInfoDto;
    }

    /** 获取 区域市场 */
    public List<AreaMarketingDto> getAreaMarketingDtos() {
        return this.areaMarketingDtos;
    }

    /** 设置 区域市场 */
    public void setAreaMarketingDtos(List<AreaMarketingDto> areaMarketingDtos) {
        this.areaMarketingDtos = areaMarketingDtos;
    }

    /** 获取 当前用户名 */
    public String getCurrentName() {
        return this.currentName;
    }

    /** 设置 当前用户名 */
    public void setCurrentName(String currentName) {
        this.currentName = currentName;
    }

    /** 获取 财务信息Dto */
    public FinanceInfoApplyDto getFinanceInfoApplyDto() {
        return this.financeInfoApplyDto;
    }

    /** 设置 财务信息Dto */
    public void setFinanceInfoApplyDto(FinanceInfoApplyDto financeInfoApplyDto) {
        this.financeInfoApplyDto = financeInfoApplyDto;
    }

    /** 获取 表单编号 */
    public String getFormNo() {
        return this.formNo;
    }

    /** 设置 表单编号 */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /** 获取 表单状态 */
    public String getFormStatus() {
        return this.formStatus;
    }

    /** 设置 表单状态 */
    public void setFormStatus(String formStatus) {
        this.formStatus = formStatus;
    }

    /** 获取 表单类型 */
    public String getFormType() {
        return this.formType;
    }

    /** 设置 表单类型 */
    public void setFormType(String formType) {
        this.formType = formType;
    }

    /** 获取 管理信息Dto */
    public ManageInfoDto getManageInfoDto() {
        return this.manageInfoDto;
    }

    /** 设置 管理信息Dto */
    public void setManageInfoDto(ManageInfoDto manageInfoDto) {
        this.manageInfoDto = manageInfoDto;
    }

    /** 获取 当前所属组织信息Vo (大区/分公司/xxx ) */
    public OrgVo getOrgVo() {
        return this.orgVo;
    }

    /** 设置 当前所属组织信息Vo (大区/分公司/xxx ) */
    public void setOrgVo(OrgVo orgVo) {
        this.orgVo = orgVo;
    }

    /** 获取 组织1 */
    public OrgVo getOrgVo1() {
        return this.orgVo1;
    }

    /** 设置 组织1 */
    public void setOrgVo1(OrgVo orgVo1) {
        this.orgVo1 = orgVo1;
    }

    /** 获取 组织2 */
    public OrgVo getOrgVo2() {
        return this.orgVo2;
    }

    /** 设置 组织2 */
    public void setOrgVo2(OrgVo orgVo2) {
        this.orgVo2 = orgVo2;
    }

    /** 获取 组织3 */
    public OrgVo getOrgVo3() {
        return this.orgVo3;
    }

    /** 设置 组织3 */
    public void setOrgVo3(OrgVo orgVo3) {
        this.orgVo3 = orgVo3;
    }

    /** 获取 组织4 */
    public OrgVo getOrgVo4() {
        return this.orgVo4;
    }

    /** 设置 组织4 */
    public void setOrgVo4(OrgVo orgVo4) {
        this.orgVo4 = orgVo4;
    }

    /** 获取 职位Vo */
    public PositionVo getPositionVo() {
        return this.positionVo;
    }

    /** 设置 职位Vo */
    public void setPositionVo(PositionVo positionVo) {
        this.positionVo = positionVo;
    }

    /** 获取 促销信息Dto */
    public PromotionInfoDto getPromotionInfoDto() {
        return this.promotionInfoDto;
    }

    /** 设置 促销信息Dto */
    public void setPromotionInfoDto(PromotionInfoDto promotionInfoDto) {
        this.promotionInfoDto = promotionInfoDto;
    }

    public List<SaleLimitDto> getSaleLimitDtos() {
        return saleLimitDtos;
    }

    public void setSaleLimitDtos(List<SaleLimitDto> saleLimitDtos) {
        this.saleLimitDtos = saleLimitDtos;
    }

    /** 获取 传输信息 自定义 */
    public T getTransforDto() {
        return this.transforDto;
    }

    /** 设置 传输信息 自定义 */
    public void setTransforDto(T transforDto) {
        this.transforDto = transforDto;
    }

    /** 获取 传输信息 自定义 */
    public E getTransforDto1() {
        return this.transforDto1;
    }

    /** 设置 传输信息 自定义 */
    public void setTransforDto1(E transforDto1) {
        this.transforDto1 = transforDto1;
    }

    /** 获取 当前操作用户信息 */
    public UserInfoVo getUserInfoVo() {
        return this.userInfoVo;
    }

    /** 设置 当前操作用户信息 */
    public void setUserInfoVo(UserInfoVo userInfoVo) {
        this.userInfoVo = userInfoVo;
    }

    /** 获取 分公司*/
    public OrgVo getDepartMentVo() {
        return this.departMentVo;
    }

    /** 设置 分公司*/
    public void setDepartMentVo(OrgVo departMentVo) {
        this.departMentVo = departMentVo;
    }

    public void setFormStatusEnum(ApplyFormStatusEnum formStatusEnum) {
        this.formStatusEnum = formStatusEnum;
    }

    public ApplyFormStatusEnum getFormStatusEnum() {
        return formStatusEnum;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return contextName;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
