package com.chinayanghe.tpm.cost.rpc;

import java.util.List;

import com.chinayanghe.tpm.cost.vo.in.CostAmtQueryVo;
import com.chinayanghe.tpm.cost.vo.in.SaleLimitDetailVo;
import com.chinayanghe.tpm.cost.vo.in.SaleLimitVo;
import com.chinayanghe.tpm.cost.vo.out.CostBudgetAmtVo;

/**
 * 销量控制RPC
 */
public interface SaleLimitRpcService {


    /***
     * 写入销量控制明细信息
     * @param voList 数据List
     * @return true 处理成功 
     */
    boolean  insertSaleLimitSeq(List<SaleLimitDetailVo> voList);
    
    /**
     * 预算需求：
		传入： 预算年度（自然年）、经销商、分公司   
		返回：  预算年度、经销商、分公司、销售额（金额汇总）
	 * @param queryVo 查询对象
     * @return 
     */
    CostBudgetAmtVo queryCostAmt(CostAmtQueryVo queryVo);
    
    /**
     * 汇总金额
     * @param queryVos  预算年度（自然年）、分公司
     * @return 预算年度、分公司、销售额（金额汇总）
     */
    List<CostBudgetAmtVo> queryCostAmt(List<CostAmtQueryVo> queryVos);
    
    /**
     * .提交核报单时，销量控制接口
     * @param saleLimitVo  销量控制信息
     * @param isUpdate  true-检查并冻结销量控制   false-只做检查操作
     * @return 返回错误信息 为空，操作成功
     */
    String saleLimitControl(SaleLimitVo saleLimitVo,Boolean isUpdate);
}
