package com.chinayanghe.tpm.cost.vo.in;

import java.io.Serializable;
import java.util.Date;

/**
 * Sap向中如推送销量数据对象
 * SaleLimitDetailDto
 * 数据库表：sale_limit_detail
 */
public class InvoiceControlDetailVo implements Serializable {


	private static final long serialVersionUID = 4854876645692834060L;
	/**
	 * 发票凭证号
	 * 表字段 : invoice_amount_control_log.invoice_no
	 */
	private String invoiceNo;

	/**
	 * 流水单据号
	 * 表字段 : invoice_amount_control_log.serial_no
	 */
	private String serialNo;

	/**
	 * 开票标示编码
	 * 表字段 : invoice_amount_control_log.ticket_mark_id
	 */
	private String ticketMarkId;

	/**
	 * 开票标示
	 * 表字段 : invoice_amount_control_log.ticket_mark
	 */
	private String ticketMark;

	/**
	 * 发票行项目号
	 * 表字段 : invoice_amount_control_log.ticket_item_no
	 */
	private String ticketItemNo;

	/**
	 * 公司编码
	 * 表字段 : invoice_amount_control_log.company_id
	 */
	private String companyId;

	/**
	 * 分公司编码
	 * 表字段 : invoice_amount_control_log.branch_company_id
	 */
	private String branchCompanyId;

	/**
	 * 经销商编码
	 * 表字段 : invoice_amount_control_log.dealer_id
	 */
	private String dealerId;

	/**
	 * 经销商名称
	 * 表字段 : invoice_amount_control_log.dealer_name
	 */
	private String dealerName;

	/**
	 * 一级渠道
	 * 表字段 : invoice_amount_control_log.level_channel_one
	 */
	private String levelChannelOne;

	/**
	 * 二级渠道
	 * 表字段 : invoice_amount_control_log.level_channel_two
	 */
	private String levelChannelTwo;

	/**
	 * 产品编码
	 * 表字段 : invoice_amount_control_log.product_id
	 */
	private String productId;

	/**
	 * 产品名称
	 * 表字段 : invoice_amount_control_log.product_name
	 */
	private String productName;

	/**
	 * 开票产品瓶数
	 */
	private int productNum;

	/**
	 * 金额
	 * 表字段 : invoice_amount_control_log.amount
	 */
	private Long amount;

	/**
	 * 定价值
	 * 表字段 : invoice_amount_control_log.real_price
	 */
	private Long realPrice;

	/**
	 * 开票日期
	 * 表字段 : invoice_amount_control_log.ticket_date
	 */
	private Date ticketDate;

	/**
	 * 状态编号  10-已转入  40-已退货
	 * 表字段 : invoice_amount_control_log.ticket_status
	 */
	private Integer ticketStatus;

	/**
	 *
	 * 表字段 : invoice_amount_control_log.create_id
	 */
	private String createId;

	/**
	 *
	 * 表字段 : invoice_amount_control_log.create_name
	 */
	private String createName;

	public String getInvoiceNo() {
		return invoiceNo;
	}

	public void setInvoiceNo(String invoiceNo) {
		this.invoiceNo = invoiceNo;
	}

	public String getSerialNo() {
		return serialNo;
	}

	public void setSerialNo(String serialNo) {
		this.serialNo = serialNo;
	}

	public String getTicketMarkId() {
		return ticketMarkId;
	}

	public void setTicketMarkId(String ticketMarkId) {
		this.ticketMarkId = ticketMarkId;
	}

	public String getTicketMark() {
		return ticketMark;
	}

	public void setTicketMark(String ticketMark) {
		this.ticketMark = ticketMark;
	}

	public String getTicketItemNo() {
		return ticketItemNo;
	}

	public void setTicketItemNo(String ticketItemNo) {
		this.ticketItemNo = ticketItemNo;
	}

	public String getCompanyId() {
		return companyId;
	}

	public void setCompanyId(String companyId) {
		this.companyId = companyId;
	}

	public String getBranchCompanyId() {
		return branchCompanyId;
	}

	public void setBranchCompanyId(String branchCompanyId) {
		this.branchCompanyId = branchCompanyId;
	}

	public String getDealerId() {
		return dealerId;
	}

	public void setDealerId(String dealerId) {
		this.dealerId = dealerId;
	}

	public String getDealerName() {
		return dealerName;
	}

	public void setDealerName(String dealerName) {
		this.dealerName = dealerName;
	}

	public String getLevelChannelOne() {
		return levelChannelOne;
	}

	public void setLevelChannelOne(String levelChannelOne) {
		this.levelChannelOne = levelChannelOne;
	}

	public String getLevelChannelTwo() {
		return levelChannelTwo;
	}

	public void setLevelChannelTwo(String levelChannelTwo) {
		this.levelChannelTwo = levelChannelTwo;
	}

	public String getProductId() {
		return productId;
	}

	public void setProductId(String productId) {
		this.productId = productId;
	}

	public String getProductName() {
		return productName;
	}

	public void setProductName(String productName) {
		this.productName = productName;
	}

	public int getProductNum() {
		return productNum;
	}

	public void setProductNum(int productNum) {
		this.productNum = productNum;
	}

	public Long getAmount() {
		return amount;
	}

	public void setAmount(Long amount) {
		this.amount = amount;
	}

	public Long getRealPrice() {
		return realPrice;
	}

	public void setRealPrice(Long realPrice) {
		this.realPrice = realPrice;
	}

	public Date getTicketDate() {
		return ticketDate;
	}

	public void setTicketDate(Date ticketDate) {
		this.ticketDate = ticketDate;
	}

	public Integer getTicketStatus() {
		return ticketStatus;
	}

	public void setTicketStatus(Integer ticketStatus) {
		this.ticketStatus = ticketStatus;
	}

	public String getCreateId() {
		return createId;
	}

	public void setCreateId(String createId) {
		this.createId = createId;
	}

	public String getCreateName() {
		return createName;
	}

	public void setCreateName(String createName) {
		this.createName = createName;
	}
}