
package com.chinayanghe.tpm.cost.rpc;

import java.util.List;

import com.chinayanghe.tpm.cost.vo.in.CostDetailQueryVo;
import com.chinayanghe.tpm.cost.vo.in.CostHeadQueryVo;
import com.chinayanghe.tpm.cost.vo.out.CostRegisterEvidenceResVo;
import com.chinayanghe.tpm.cost.vo.out.CostRegisterFormResVo;
import com.chinayanghe.tpm.cost.vo.out.GuestReceiveFormVo;
import com.chinayanghe.tpm.cost.vo.out.datahead.ActivityBaseInfoVo;

import cn.com.bizunited.cp.common.pagination.Page;
import cn.com.bizunited.cp.common.pagination.Pageable;
import com.chinayanghe.tpm.cost.vo.out.datahead.ManageInfoVo;

/**
 * 费用表单接口类
 * @author arthur
 *
 */
public interface CostFormRpcService {

	final String ACTIVITYENUM_PRE="activity";
	/**
	 * 开发编号 QYX_TPM_INTF_0005 获取登记取证字段
	 * @param registerNo 登记单号
	 * @param registerTitle 登记单标题
	 * @param terminalCodeList 终端编码-传终端编码Code
	 * @return
	 */
	CostRegisterFormResVo findCostRegisterFormItems(String registerNo,String registerTitle,List<String> terminalCodeList);
	

	
	/**
	 *开发编号 QYX_TPM_INTF_0005  获取登记取证字段
	 *@param registerNo 登记单号
	 *@param ltemNo  行号
	* @return
	 */
	CostRegisterEvidenceResVo getCostRegisterEvidence(String registerNo,String ltemNo);
	
	
	 /**
     * 根据岗位获取表单
     * 只查询未审核
     * @param positionCode 岗位编号
     * @param type 表单类型
     * @return  List<ActivityBaseInfoVo>
     */
    public List<CostRegisterFormResVo> getFormsByPosition(String positionCode, String type);

    /**
     * 根据表单编号获取表单头信息
     * @param formNo 表单编号
     * @return com.chinayanghe.tpm.cost.vo.ActivityBaseInfoVo
     */
    public CostRegisterFormResVo findByFormNo(String formNo);
    
    /**
     * 获取登记单、核报单表头信息接口：通过输入参数获取登记单、核报单表头信息（需要分页查询）
     * @param  page  当前页
     * @param  rows  每页条数
     * @param  queryVo  查询条件
     * @return 返回分页后的数据信息
     */
    public Page<ActivityBaseInfoVo> findActivityBaseInfoPage(int page,int rows, CostHeadQueryVo queryVo);
    
    /**
     * 获取登记单、核报单表头明细信息接口：通过输入参数获取登记单、核报单表头信息（需要分页查询）
     * 要根据活动类型 强转成对应的活动明细类型
     * 如：消费者活动推广 对应的登记单对象 com.chinayanghe.tpm.cost.vo.out.datadetail.regist.CustomerFeastRegistVo
     *                对应的核报单对象 com.chinayanghe.tpm.cost.vo.out.datadetail.pay.CustomerFeastPayVo
	 * @param  page  当前页
     * @param  rows  每页条数
     * @param  queryVo  查询条件
     * @return 返回分页后的数据信息                          
     */
    public Page<?> findActivityDetailInfoPage(int page,int rows, CostDetailQueryVo queryVo);

	/**
	 * 获取来宾接待中的用餐明细及住宿用酒明细
	 * @param formNo 表单号
	 * @return
	 */
	public GuestReceiveFormVo findGuestReceiveFormDetail(String formNo);

	/**
	 * 根据表单编号获取表单管理信息
	 * @param formNo 表单编号
	 */
    public ManageInfoVo findManageInfoVoByFormNo(String formNo);
    /**
     * 根据表单编号获取活动信息
     * @param formNo 表单编号
     */
    public ActivityBaseInfoVo findActivityBaseInfoVoByFormNo(String formNo);
}
