package com.chinayanghe.tpm.cost.vo;

import com.chinayanghe.tpm.cost.ApplyFormStatusEnum;
import com.chinayanghe.tpm.cost.dto.*;

import java.util.List;

/**
 * 该模板只适用于 页面的数据传入 转成相应的数据设置
 * @ClassName: com.chinayanghe.tpm.cost.vo.swagger
 * Created by OmarZhang on 2017/5/21 12:50.
 */
public class TemplateTransforVo<T, E> {

    /** 管理信息Dto */
    private ManageInfoDto manageInfoDto;

    /** 活动信息Dto */
    private ActivityBaseInfoDto activityBaseInfoDto;

    /** 财务信息Dto */
    private FinanceInfoApplyDto financeInfoApplyDto;

    /** 促销信息Dto */
    private PromotionInfoDto promotionInfoDto;

    /** 区域市场 */
    private List<AreaMarketingDto> areaMarketingDtos;

    /** 销量控制 */
    private List<SaleLimitDto> saleLimitDtos;

    /** 传输信息 自定义 */
    private T transforDto;

    /** 传输信息 自定义 */
    private E transforDto1;



    /** 表单编号 */
    private String formNo;

    /** 表单类型 */
    private String formType;

    /** 表单状态 */
    private String formStatus;
    /** 表单状态枚举*/
    private ApplyFormStatusEnum formStatusEnum;
    /** 应用工程名称*/
    private String contextName;

    public TemplateTransforVo() {}

    /**
     *
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param transforDto 传输信息
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              T transforDto) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.transforDto         = transforDto;
    }

    /**
     *
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param areaMarketingDtos 市场区域
     * @param transforDto 传输信息
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              List<AreaMarketingDto> areaMarketingDtos, T transforDto) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.areaMarketingDtos   = areaMarketingDtos;
        this.transforDto         = transforDto;
    }

    /**
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param transforDto 传输信息
     * @param transforDto1 传输信息2
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              T transforDto, E transforDto1) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.transforDto         = transforDto;
        this.transforDto1        = transforDto1;
    }

    /**
     *
     * @param manageInfoDto 管理信息
     * @param activityBaseInfoDto 活动信息
     * @param financeInfoApplyDto 财务信息
     * @param promotionInfoDto 促销信息
     * @param saleLimitDtos 销量控制信息
     * @param areaMarketingDtos 市场区域
     * @param transforDto 传输信息
     */
    public TemplateTransforVo(ManageInfoDto manageInfoDto, ActivityBaseInfoDto activityBaseInfoDto,
                              FinanceInfoApplyDto financeInfoApplyDto, PromotionInfoDto promotionInfoDto,
                              List<SaleLimitDto> saleLimitDtos, List<AreaMarketingDto> areaMarketingDtos,
                              T transforDto) {
        this.manageInfoDto       = manageInfoDto;
        this.activityBaseInfoDto = activityBaseInfoDto;
        this.financeInfoApplyDto = financeInfoApplyDto;
        this.promotionInfoDto    = promotionInfoDto;
        this.areaMarketingDtos   = areaMarketingDtos;
        this.saleLimitDtos       = saleLimitDtos;
        this.transforDto         = transforDto;
    }

    /** 获取 活动信息Dto */
    public ActivityBaseInfoDto getActivityBaseInfoDto() {
        return this.activityBaseInfoDto;
    }

    /** 设置 活动信息Dto */
    public void setActivityBaseInfoDto(ActivityBaseInfoDto activityBaseInfoDto) {
        this.activityBaseInfoDto = activityBaseInfoDto;
    }

    /** 获取 区域市场 */
    public List<AreaMarketingDto> getAreaMarketingDtos() {
        return this.areaMarketingDtos;
    }

    /** 设置 区域市场 */
    public void setAreaMarketingDtos(List<AreaMarketingDto> areaMarketingDtos) {
        this.areaMarketingDtos = areaMarketingDtos;
    }

    /** 获取 财务信息Dto */
    public FinanceInfoApplyDto getFinanceInfoApplyDto() {
        return this.financeInfoApplyDto;
    }

    /** 设置 财务信息Dto */
    public void setFinanceInfoApplyDto(FinanceInfoApplyDto financeInfoApplyDto) {
        this.financeInfoApplyDto = financeInfoApplyDto;
    }

    /** 获取 表单编号 */
    public String getFormNo() {
        return this.formNo;
    }

    /** 设置 表单编号 */
    public void setFormNo(String formNo) {
        this.formNo = formNo;
    }

    /** 获取 表单状态 */
    public String getFormStatus() {
        return this.formStatus;
    }

    /** 设置 表单状态 */
    public void setFormStatus(String formStatus) {
        this.formStatus = formStatus;
    }

    /** 获取 表单类型 */
    public String getFormType() {
        return this.formType;
    }

    /** 设置 表单类型 */
    public void setFormType(String formType) {
        this.formType = formType;
    }

    /** 获取 管理信息Dto */
    public ManageInfoDto getManageInfoDto() {
        return this.manageInfoDto;
    }

    /** 设置 管理信息Dto */
    public void setManageInfoDto(ManageInfoDto manageInfoDto) {
        this.manageInfoDto = manageInfoDto;
    }

    /** 获取 促销信息Dto */
    public PromotionInfoDto getPromotionInfoDto() {
        return this.promotionInfoDto;
    }

    /** 设置 促销信息Dto */
    public void setPromotionInfoDto(PromotionInfoDto promotionInfoDto) {
        this.promotionInfoDto = promotionInfoDto;
    }

    public List<SaleLimitDto> getSaleLimitDtos() {
        return saleLimitDtos;
    }

    public void setSaleLimitDtos(List<SaleLimitDto> saleLimitDtos) {
        this.saleLimitDtos = saleLimitDtos;
    }

    /** 获取 传输信息 自定义 */
    public T getTransforDto() {
        return this.transforDto;
    }

    /** 设置 传输信息 自定义 */
    public void setTransforDto(T transforDto) {
        this.transforDto = transforDto;
    }

    /** 获取 传输信息 自定义 */
    public E getTransforDto1() {
        return this.transforDto1;
    }

    /** 设置 传输信息 自定义 */
    public void setTransforDto1(E transforDto1) {
        this.transforDto1 = transforDto1;
    }


    public void setFormStatusEnum(ApplyFormStatusEnum formStatusEnum) {
        this.formStatusEnum = formStatusEnum;
    }

    public ApplyFormStatusEnum getFormStatusEnum() {
        return formStatusEnum;
    }

    public void setContextName(String contextName) {
        this.contextName = contextName;
    }

    public String getContextName() {
        return contextName;
    }
}


//~ Formatted by Jindent --- http://www.jindent.com
