/**
 * 2017 
 * 2017年5月5日  
 * 上午9:40:34
 * BizResponseJson.java
 * com.chinayanghe.tpm.cost.vo.out
 * budget-rpc
 */
package com.chinayanghe.tpm.cost.vo.out;

import java.io.Serializable;

/**
 * 业务层面返回信息
 * @author yangshuo
 *
 */
public class BizResponseJson implements Serializable {
	/**
	 * 1000	执行成功
		1100~1199	输入数据检查的错误消息
		1200~1299	获取可用列支渠道的错误消息
	 */
	public final static int SC_OK=1000;
	
	public final static int FL_ERROR=1100;

    /** 状态嘛*/
    private int code;
    /** 返回内容*/
    private Object body;
    /** 消息*/
    private String message;

    public BizResponseJson() {
         this.code  = SC_OK;
         this.message = "成功";
    }

    public BizResponseJson(Object body) {
        this.message = "成功";
        this.code = SC_OK;
        this.body = body;
    }

    public BizResponseJson(int code, Object body, String message) {
        this.code = code;
        this.body = body;
        this.message = message;
    }

    /** 获取 状态嘛*/
    public int getCode() {
        return this.code;
    }

    /** 设置 状态嘛*/
    public void setCode(int code) {
        this.code = code;
    }

    /** 获取 返回内容*/
    public Object getBody() {
        return this.body;
    }

    /** 设置 返回内容*/
    public void setBody(Object body) {
        this.body = body;
    }

    /** 获取 消息*/
    public String getMessage() {
        return this.message;
    }

    /** 设置 消息*/
    public void setMessage(String message) {
        this.message = message;
    }

    @Override
    public String toString() {
        return "BizResponseJson{" +
                "code=" + code +
                ", body=" + body +
                ", message='" + message + '\'' +
                '}';
    }
}
