package com.chinayanghe.tpm.rpc.vo.financeInfo;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * 财务申请扩展表
 * FinanceInfoApplyExtDto
 * 数据库表：finance_info_apply_ext
 */
public class FinanceInfoApplyExtVo implements Serializable {

    /**
     * 
     * 表字段 : finance_info_apply_ext.ID
     */
    private Integer id;

    /**
     * 申请单号
     * 表字段 : finance_info_apply_ext.apply_no
     */
    private String applyNo;

    /**
     * 上年度该项目实施费用(分)
     * 表字段 : finance_info_apply_ext.last_project_ implement_cost
     */
    private Integer lastProjectImplementCost;

    /**
     * 该分公司销售指标(分)
     * 表字段 : finance_info_apply_ext.sales_target
     */
    private Integer salesTarget;

    /**
     * 该分公司广告年度预算(分)
     * 表字段 : finance_info_apply_ext.ad_year_budget
     */
    private Integer adYearBudget;

    /**
     * 该分公司已实施广告总额(分)
     * 表字段 : finance_info_apply_ext.has_implement_ad_amt
     */
    private Integer hasImplementAdAmt;

    /**
     * 已实施广告项目占全年预算比例/%
     * 表字段 : finance_info_apply_ext.has_implement_ad_scale
     */
    private BigDecimal hasImplementAdScale;

    /**
     * 项目性价比描述
     * 表字段 : finance_info_apply_ext.project_desc
     */
    private String projectDesc;

    /**
     * 区域竞品投放情况
     * 表字段 : finance_info_apply_ext.area_input_desc
     */
    private String areaInputDesc;

    /**
     * 该市场已投放项目描述
     * 表字段 : finance_info_apply_ext.maket_input_desc
     */
    private String maketInputDesc;

    /**
     * This field was generated by MyBatis Generator.
     * This field corresponds to the database table finance_info_apply_ext
     *
     * @mbggenerated Fri Jun 23 11:38:26 CST 2017
     */
    private static final long serialVersionUID = 1L;

    /**
     * 获取  字段:finance_info_apply_ext.ID
     *
     * @return finance_info_apply_ext.ID, 
     */
    public Integer getId() {
        return id;
    }

    /**
     * 设置  字段:finance_info_apply_ext.ID
     *
     * @param id the value for finance_info_apply_ext.ID, 
     */
    public void setId(Integer id) {
        this.id = id;
    }

    /**
     * 获取 申请单号 字段:finance_info_apply_ext.apply_no
     *
     * @return finance_info_apply_ext.apply_no, 申请单号
     */
    public String getApplyNo() {
        return applyNo;
    }

    /**
     * 设置 申请单号 字段:finance_info_apply_ext.apply_no
     *
     * @param applyNo the value for finance_info_apply_ext.apply_no, 申请单号
     */
    public void setApplyNo(String applyNo) {
        this.applyNo = applyNo;
    }

    /**
     * 获取 上年度该项目实施费用(分) 字段:finance_info_apply_ext.last_project_ implement_cost
     *
     * @return finance_info_apply_ext.last_project_ implement_cost, 上年度该项目实施费用(分)
     */
    public Integer getLastProjectImplementCost() {
        return lastProjectImplementCost;
    }

    /**
     * 设置 上年度该项目实施费用(分) 字段:finance_info_apply_ext.last_project_ implement_cost
     *
     * @param lastProjectImplementCost the value for finance_info_apply_ext.last_project_ implement_cost, 上年度该项目实施费用(分)
     */
    public void setLastProjectImplementCost(Integer lastProjectImplementCost) {
        this.lastProjectImplementCost = lastProjectImplementCost;
    }

    /**
     * 获取 该分公司销售指标(分) 字段:finance_info_apply_ext.sales_target
     *
     * @return finance_info_apply_ext.sales_target, 该分公司销售指标(分)
     */
    public Integer getSalesTarget() {
        return salesTarget;
    }

    /**
     * 设置 该分公司销售指标(分) 字段:finance_info_apply_ext.sales_target
     *
     * @param salesTarget the value for finance_info_apply_ext.sales_target, 该分公司销售指标(分)
     */
    public void setSalesTarget(Integer salesTarget) {
        this.salesTarget = salesTarget;
    }

    /**
     * 获取 该分公司广告年度预算(分) 字段:finance_info_apply_ext.ad_year_budget
     *
     * @return finance_info_apply_ext.ad_year_budget, 该分公司广告年度预算(分)
     */
    public Integer getAdYearBudget() {
        return adYearBudget;
    }

    /**
     * 设置 该分公司广告年度预算(分) 字段:finance_info_apply_ext.ad_year_budget
     *
     * @param adYearBudget the value for finance_info_apply_ext.ad_year_budget, 该分公司广告年度预算(分)
     */
    public void setAdYearBudget(Integer adYearBudget) {
        this.adYearBudget = adYearBudget;
    }

    /**
     * 获取 该分公司已实施广告总额(分) 字段:finance_info_apply_ext.has_implement_ad_amt
     *
     * @return finance_info_apply_ext.has_implement_ad_amt, 该分公司已实施广告总额(分)
     */
    public Integer getHasImplementAdAmt() {
        return hasImplementAdAmt;
    }

    /**
     * 设置 该分公司已实施广告总额(分) 字段:finance_info_apply_ext.has_implement_ad_amt
     *
     * @param hasImplementAdAmt the value for finance_info_apply_ext.has_implement_ad_amt, 该分公司已实施广告总额(分)
     */
    public void setHasImplementAdAmt(Integer hasImplementAdAmt) {
        this.hasImplementAdAmt = hasImplementAdAmt;
    }

    /**
     * 获取 已实施广告项目占全年预算比例/% 字段:finance_info_apply_ext.has_implement_ad_scale
     *
     * @return finance_info_apply_ext.has_implement_ad_scale, 已实施广告项目占全年预算比例/%
     */
    public BigDecimal getHasImplementAdScale() {
        return hasImplementAdScale;
    }

    /**
     * 设置 已实施广告项目占全年预算比例/% 字段:finance_info_apply_ext.has_implement_ad_scale
     *
     * @param hasImplementAdScale the value for finance_info_apply_ext.has_implement_ad_scale, 已实施广告项目占全年预算比例/%
     */
    public void setHasImplementAdScale(BigDecimal hasImplementAdScale) {
        this.hasImplementAdScale = hasImplementAdScale;
    }

    /**
     * 获取 项目性价比描述 字段:finance_info_apply_ext.project_desc
     *
     * @return finance_info_apply_ext.project_desc, 项目性价比描述
     */
    public String getProjectDesc() {
        return projectDesc;
    }

    /**
     * 设置 项目性价比描述 字段:finance_info_apply_ext.project_desc
     *
     * @param projectDesc the value for finance_info_apply_ext.project_desc, 项目性价比描述
     */
    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc;
    }

    /**
     * 获取 区域竞品投放情况 字段:finance_info_apply_ext.area_input_desc
     *
     * @return finance_info_apply_ext.area_input_desc, 区域竞品投放情况
     */
    public String getAreaInputDesc() {
        return areaInputDesc;
    }

    /**
     * 设置 区域竞品投放情况 字段:finance_info_apply_ext.area_input_desc
     *
     * @param areaInputDesc the value for finance_info_apply_ext.area_input_desc, 区域竞品投放情况
     */
    public void setAreaInputDesc(String areaInputDesc) {
        this.areaInputDesc = areaInputDesc;
    }

    /**
     * 获取 该市场已投放项目描述 字段:finance_info_apply_ext.maket_input_desc
     *
     * @return finance_info_apply_ext.maket_input_desc, 该市场已投放项目描述
     */
    public String getMaketInputDesc() {
        return maketInputDesc;
    }

    /**
     * 设置 该市场已投放项目描述 字段:finance_info_apply_ext.maket_input_desc
     *
     * @param maketInputDesc the value for finance_info_apply_ext.maket_input_desc, 该市场已投放项目描述
     */
    public void setMaketInputDesc(String maketInputDesc) {
        this.maketInputDesc = maketInputDesc;
    }
}