/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.config;

import com.deepoove.poi.config.Configure;
import com.deepoove.poi.policy.RenderPolicy;
import com.deepoove.poi.render.compute.DefaultELRenderDataCompute;
import com.deepoove.poi.render.compute.RenderDataComputeFactory;
import com.deepoove.poi.render.compute.SpELRenderDataCompute;
import com.deepoove.poi.resolver.ElementTemplateFactory;
import com.deepoove.poi.template.MetaTemplate;
import com.deepoove.poi.util.RegexUtils;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xddf.usermodel.chart.ChartTypes;

public class ConfigureBuilder {
    private Configure config = new Configure();
    private boolean usedSpringEL;
    private boolean changeRegex;

    ConfigureBuilder() {
    }

    public ConfigureBuilder buildGramer(String prefix, String suffix) {
        this.config.gramerPrefix = prefix;
        this.config.gramerSuffix = suffix;
        return this;
    }

    public ConfigureBuilder buidIterableLeft(char c) {
        this.config.iterable = Pair.of((Object)Character.valueOf(c), (Object)this.config.iterable.getRight());
        return this;
    }

    public ConfigureBuilder buildGrammerRegex(String reg) {
        this.changeRegex = true;
        this.config.grammerRegex = reg;
        return this;
    }

    public ConfigureBuilder useSpringEL() {
        return this.useSpringEL(true);
    }

    public ConfigureBuilder useSpringEL(boolean isStrict) {
        this.usedSpringEL = true;
        return this.setRenderDataComputeFactory(model -> new SpELRenderDataCompute(model, isStrict));
    }

    public ConfigureBuilder useSpringEL(Map<String, Method> spELFunction) {
        this.usedSpringEL = true;
        return this.setRenderDataComputeFactory(model -> new SpELRenderDataCompute(model, true, spELFunction));
    }

    public ConfigureBuilder useDefaultEL(boolean isStrict) {
        this.usedSpringEL = false;
        return this.setRenderDataComputeFactory(model -> new DefaultELRenderDataCompute(model, isStrict));
    }

    public ConfigureBuilder setValidErrorHandler(Configure.ValidErrorHandler handler) {
        this.config.handler = handler;
        return this;
    }

    public ConfigureBuilder setRenderDataComputeFactory(RenderDataComputeFactory renderDataComputeFactory) {
        this.config.renderDataComputeFactory = renderDataComputeFactory;
        return this;
    }

    public ConfigureBuilder setElementTemplateFactory(ElementTemplateFactory elementTemplateFactory) {
        this.config.elementTemplateFactory = elementTemplateFactory;
        return this;
    }

    public ConfigureBuilder addPlugin(char c, RenderPolicy policy) {
        this.config.plugin(c, policy);
        return this;
    }

    public ConfigureBuilder addPlugin(Class<? extends MetaTemplate> clazz, RenderPolicy policy) {
        this.config.plugin(clazz, policy);
        return this;
    }

    public ConfigureBuilder addPlugin(ChartTypes chartType, RenderPolicy policy) {
        this.config.plugin(chartType, policy);
        return this;
    }

    public ConfigureBuilder bind(String tagName, RenderPolicy policy) {
        this.config.customPolicy(tagName, policy);
        return this;
    }

    public Configure build() {
        if (this.usedSpringEL && !this.changeRegex) {
            this.config.grammerRegex = RegexUtils.createGeneral(this.config.gramerPrefix, this.config.gramerSuffix);
        }
        return this.config;
    }
}

