/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.expression;

import com.deepoove.poi.expression.Name;
import java.lang.reflect.Field;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FieldFinder {
    private static Logger logger = LoggerFactory.getLogger(FieldFinder.class);
    private static LinkedHashMap<Class<?>, Field[]> cache = new LinkedHashMap<Class<?>, Field[]>(32, 0.75f, true){
        private static final long serialVersionUID = -4306886008010847817L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Class<?>, Field[]> eldest) {
            return this.size() > 20;
        }
    };

    FieldFinder() {
    }

    static Field find(Class<?> objClass, String key) {
        Field field = null;
        for (Class<?> clazz = objClass; clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = FieldFinder.findInClazz(clazz, key);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
            catch (Exception e) {
                logger.warn("Error read the property:" + key + " from " + objClass);
            }
        }
        return null;
    }

    static Field findInClazz(Class<?> clazz, String key) throws NoSuchFieldException {
        Field field = null;
        try {
            field = clazz.getDeclaredField(key);
            return field;
        }
        catch (Exception exception) {
            Field[] fields = cache.get(clazz);
            if (null == fields) {
                fields = clazz.getDeclaredFields();
                cache.put(clazz, fields);
            }
            for (Field f : fields) {
                Name annotation = f.getAnnotation(Name.class);
                if (null == annotation || !key.equals(annotation.value())) continue;
                return f;
            }
            throw new NoSuchFieldException(key);
        }
    }
}

