/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.resolver;

import com.deepoove.poi.resolver.RunEdge;
import com.deepoove.poi.util.StyleUtils;
import com.deepoove.poi.xwpf.XWPFParagraphWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.poi.xwpf.usermodel.XWPFParagraph;
import org.apache.poi.xwpf.usermodel.XWPFRun;
import org.apache.xmlbeans.QNameSet;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTBr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTEmpty;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTR;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTText;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.impl.CTRImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunningRunParagraph {
    private static final Logger LOG = LoggerFactory.getLogger(RunningRunParagraph.class);
    static QNameSet qname = QNameSet.forArray((QName[])new QName[]{new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "br"), new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "t"), new QName("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "cr")});
    private XWPFParagraphWrapper paragraph;
    private List<XWPFRun> runs;
    List<Pair<RunEdge, RunEdge>> pairs = new ArrayList<Pair<RunEdge, RunEdge>>();

    public RunningRunParagraph(XWPFParagraph paragraph, Pattern pattern) {
        this.paragraph = new XWPFParagraphWrapper(paragraph);
        this.runs = paragraph.getRuns();
        if (null == this.runs || this.runs.isEmpty()) {
            return;
        }
        Matcher matcher = pattern.matcher(this.getParagraphText(paragraph));
        if (matcher.find()) {
            this.refactorParagraph();
        }
        this.buildRunEdge(pattern);
    }

    private String getParagraphText(XWPFParagraph paragraph) {
        StringBuilder out = new StringBuilder(64);
        for (XWPFRun run : this.runs) {
            out.append(run.text());
        }
        return out.toString();
    }

    public List<XWPFRun> refactorRun() {
        if (this.pairs.isEmpty()) {
            return null;
        }
        ArrayList<XWPFRun> templateRuns = new ArrayList<XWPFRun>();
        int size = this.pairs.size();
        for (int n = size - 1; n >= 0; --n) {
            XWPFRun extraRun;
            String extra;
            Pair<RunEdge, RunEdge> runEdgePair = this.pairs.get(n);
            RunEdge startEdge = (RunEdge)runEdgePair.getLeft();
            RunEdge endEdge = (RunEdge)runEdgePair.getRight();
            int startRunPos = startEdge.getRunPos();
            int endRunPos = endEdge.getRunPos();
            int startOffset = startEdge.getRunEdge();
            int endOffset = endEdge.getRunEdge();
            String startText = this.runs.get(startRunPos).text();
            String endText = this.runs.get(endRunPos).text();
            if (endOffset + 1 >= endText.length()) {
                if (startRunPos != endRunPos) {
                    this.paragraph.removeRun(endRunPos);
                }
            } else {
                extra = endText.substring(endOffset + 1, endText.length());
                if (startRunPos == endRunPos) {
                    extraRun = this.paragraph.insertNewRun(endRunPos + 1);
                    StyleUtils.styleRun(extraRun, this.runs.get(endRunPos));
                    this.buildExtra(extra, extraRun);
                } else {
                    extraRun = this.runs.get(endRunPos);
                    this.buildExtra(extra, extraRun);
                }
            }
            for (int m = endRunPos - 1; m > startRunPos; --m) {
                this.paragraph.removeRun(m);
            }
            if (startOffset <= 0) {
                XWPFRun templateRun = this.runs.get(startRunPos);
                templateRun.setText(startEdge.getTag(), 0);
                templateRuns.add(this.runs.get(startRunPos));
                continue;
            }
            extra = startText.substring(0, startOffset);
            extraRun = this.runs.get(startRunPos);
            this.buildExtra(extra, extraRun);
            XWPFRun templateRun = this.paragraph.insertNewRun(startRunPos + 1);
            StyleUtils.styleRun(templateRun, extraRun);
            templateRun.setText(startEdge.getTag(), 0);
            templateRuns.add(this.runs.get(startRunPos + 1));
        }
        return templateRuns;
    }

    private void buildExtra(String extra, XWPFRun extraRun) {
        extraRun.setText(extra, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refactorParagraph() {
        for (int i = this.runs.size() - 1; i >= 0; --i) {
            int sizeOfCrArray;
            XWPFRun xwpfRun = this.runs.get(i);
            CTR ctr = xwpfRun.getCTR();
            CTRImpl ctrimpl = (CTRImpl)ctr;
            int sizeOfBrArray = ctr.sizeOfBrArray();
            if (sizeOfBrArray + (sizeOfCrArray = ctr.sizeOfCrArray()) <= 0) continue;
            Object object = ctrimpl.monitor();
            synchronized (object) {
                ArrayList localArrayList = new ArrayList();
                ctrimpl.get_store().find_all_element_users(qname, localArrayList);
                int size = localArrayList.size();
                for (int j = size - 1; j >= 0; --j) {
                    XWPFRun insertNewRun;
                    Object obj = localArrayList.get(j);
                    if (obj instanceof CTEmpty) {
                        insertNewRun = this.paragraph.insertNewRun(i + 1);
                        String tagName = ((CTEmpty)obj).getDomNode().getNodeName();
                        if ("w:br".equals(tagName) || "br".equals(tagName)) {
                            insertNewRun.addBreak();
                        }
                        if (!"w:cr".equals(tagName) && !"cr".equals(tagName)) continue;
                        insertNewRun.addCarriageReturn();
                        continue;
                    }
                    if (obj instanceof CTBr) {
                        insertNewRun = this.paragraph.insertNewRun(i + 1);
                        CTBr addNewBr = insertNewRun.getCTR().addNewBr();
                        if (null != ((CTBr)obj).getType()) {
                            addNewBr.setType(((CTBr)obj).getType());
                        }
                        if (null == ((CTBr)obj).getClear()) continue;
                        addNewBr.setClear(((CTBr)obj).getClear());
                        continue;
                    }
                    if (!(obj instanceof CTText)) continue;
                    insertNewRun = this.paragraph.insertNewRun(i + 1);
                    StyleUtils.styleRun(insertNewRun, xwpfRun);
                    insertNewRun.setText(((CTText)obj).getStringValue());
                }
                this.paragraph.removeRun(i);
                continue;
            }
        }
        this.runs = this.paragraph.getParagraph().getRuns();
    }

    private void buildRunEdge(Pattern pattern) {
        Matcher matcher = pattern.matcher(this.getParagraphText(this.paragraph.getParagraph()));
        while (matcher.find()) {
            this.pairs.add((Pair<RunEdge, RunEdge>)ImmutablePair.of((Object)new RunEdge(matcher.start(), matcher.group()), (Object)new RunEdge(matcher.end(), matcher.group())));
        }
        if (this.pairs.isEmpty()) {
            return;
        }
        boolean endflag = false;
        int size = this.runs.size();
        int cursor = 0;
        int pos = 0;
        Pair<RunEdge, RunEdge> pair = this.pairs.get(pos);
        RunEdge startEdge = (RunEdge)pair.getLeft();
        RunEdge endEdge = (RunEdge)pair.getRight();
        int start = startEdge.getAllEdge();
        int end = endEdge.getAllEdge();
        for (int i = 0; i < size; ++i) {
            XWPFRun run = this.runs.get(i);
            String text = run.text();
            if (null == text) {
                LOG.warn("found the empty text run,may be produce bug:" + run);
                cursor += run.toString().length();
                continue;
            }
            LOG.debug(text);
            if (text.length() + cursor < start) {
                cursor += text.length();
                continue;
            }
            for (int offset = 0; offset < text.length(); ++offset) {
                if (cursor + offset == start) {
                    startEdge.setRunPos(i);
                    startEdge.setRunEdge(offset);
                    startEdge.setText(text);
                }
                if (cursor + offset != end - 1) continue;
                endEdge.setRunPos(i);
                endEdge.setRunEdge(offset);
                endEdge.setText(text);
                if (pos == this.pairs.size() - 1) {
                    endflag = true;
                    break;
                }
                pair = this.pairs.get(++pos);
                startEdge = (RunEdge)pair.getLeft();
                endEdge = (RunEdge)pair.getRight();
                start = startEdge.getAllEdge();
                end = endEdge.getAllEdge();
            }
            if (endflag) break;
            cursor += text.length();
        }
        this.loggerInfo();
    }

    public void loggerInfo() {
        for (Pair<RunEdge, RunEdge> runEdges : this.pairs) {
            LOG.debug("[Start]:" + ((RunEdge)runEdges.getLeft()).toString());
            LOG.debug("[End]:" + ((RunEdge)runEdges.getRight()).toString());
        }
    }
}

