/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import com.deepoove.poi.XWPFTemplate;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.poi.ooxml.POIXMLDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PoitlIOUtils {
    private static Logger logger = LoggerFactory.getLogger(PoitlIOUtils.class);

    public static InputStream docToInputStream(POIXMLDocument doc) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            doc.write((OutputStream)out);
            byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable throwable) {
            PoitlIOUtils.closeQuietlyMulti(new Closeable[]{doc, out});
            throw throwable;
        }
        PoitlIOUtils.closeQuietlyMulti(new Closeable[]{doc, out});
        return byteArrayInputStream;
    }

    public static InputStream templateToInputStream(XWPFTemplate doc) throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            doc.write(out);
            byteArrayInputStream = new ByteArrayInputStream(out.toByteArray());
        }
        catch (Throwable throwable) {
            PoitlIOUtils.closeQuietlyMulti(doc, out);
            throw throwable;
        }
        PoitlIOUtils.closeQuietlyMulti(doc, out);
        return byteArrayInputStream;
    }

    public static void closeLoggerQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException ignored) {
                logger.error("Close failed", (Throwable)ignored);
            }
        }
    }

    public static void closeQuietlyMulti(Closeable ... cls) {
        for (Closeable c : cls) {
            PoitlIOUtils.closeQuietly(c);
        }
    }

    public static void closeQuietly(Closeable c) {
        if (c != null) {
            try {
                c.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

