/*
 * Decompiled with CFR 0.152.
 */
package com.deepoove.poi.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.compress.utils.IOUtils;

public class ResourceLoader {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String loadContent(String url) throws IOException {
        ClassLoader cl = ResourceLoader.getDefaultClassLoader();
        InputStream stream = null != cl ? cl.getResourceAsStream(url) : ClassLoader.getSystemResourceAsStream(url);
        try {
            String string = new String(IOUtils.toByteArray((InputStream)stream));
            return string;
        }
        finally {
            IOUtils.closeQuietly((Closeable)stream);
        }
    }

    public static InputStream load(String url) throws IOException {
        ClassLoader cl = ResourceLoader.getDefaultClassLoader();
        return null != cl ? cl.getResourceAsStream(url) : ClassLoader.getSystemResourceAsStream(url);
    }

    private static ClassLoader getDefaultClassLoader() {
        ClassLoader cl = null;
        try {
            cl = Thread.currentThread().getContextClassLoader();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (cl == null && (cl = ResourceLoader.class.getClassLoader()) == null) {
            try {
                cl = ClassLoader.getSystemClassLoader();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return cl;
    }
}

