/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.config;

import com.depotnearby.util.ConfigUtils;
import java.util.Properties;
import org.codelogger.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayConfig {
    private static final Logger logger = LoggerFactory.getLogger(AlipayConfig.class);
    public static final String CONFIG_PATH = "alipay_config.properties";
    public static final String UTF_8 = "utf-8";
    public static final String PRIVATE_KEY = "private.key";
    public static final String PARTNER = "partner";
    public static String log_path = "D:\\";
    public static String input_charset = "utf-8";
    public static String sign_type = "RSA";
    private static Properties conf;
    public static String account_name;
    public static String email;
    public static String ali_public_key;

    private AlipayConfig() {
        conf = new Properties();
        try {
            logger.info("load alipay payment configurations {}.", (Object)CONFIG_PATH);
            conf = ConfigUtils.loadFromFileOrZooKeeper(null, (String)CONFIG_PATH);
        }
        catch (Exception ex) {
            throw new RuntimeException(String.format("Failed to load conf resource [%s]", CONFIG_PATH), ex);
        }
    }

    public static AlipayConfig newInstance() {
        return AlipayConfigHolder.instance;
    }

    public String getPartner(String appId) {
        return this.getPropertyByAppId(PARTNER, appId);
    }

    public String getSellerId(String appId) {
        return this.getPartner(appId);
    }

    public String getPrivateKey(String appId) {
        return this.getPropertyByAppId(PRIVATE_KEY, appId);
    }

    private String getPropertyByAppId(String propertyKey, String appId) {
        String fixedAppId = this.getFixedAppId(appId);
        return conf.getProperty(propertyKey + "." + fixedAppId);
    }

    private String getFixedAppId(String appId) {
        return StringUtils.isBlank((String)appId) ? conf.getProperty("appid.default") : appId;
    }

    static {
        account_name = "365\u540d\u54c1\u6c47";
        email = "knight.xie@biz-united.com.cn";
        ali_public_key = "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCnxj/9qwVfgoUh/y2W89L6BkRAFljhNhgPdyPuBV64bfQNN1PjbCzkIM6qRdKBoLPXmKKMiFYnkd6rAoprih3/PrQEB/VsW8OoM8fxn67UDYuyBTqA23MML9q1+ilIZwBC2AQ2UBVOrFXfFl75p6/B5KsiNG9zpgmLCUYuLkxpLQIDAQAB";
    }

    private static class AlipayConfigHolder {
        static AlipayConfig instance = new AlipayConfig();

        private AlipayConfigHolder() {
        }
    }
}

