/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.util;

import com.alipay.config.AlipayConfig;
import com.alipay.sign.RSA;
import com.alipay.util.AlipayCore;
import com.alipay.util.AlipaySubmit;
import com.depotnearby.exception.CommonException;
import com.depotnearby.util.ConfigUtils;
import com.depotnearby.util.DateTool;
import com.depotnearby.util.StringTool;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlipayFactory {
    private static final Logger logger = LoggerFactory.getLogger(AlipayFactory.class);
    private Properties conf = ConfigUtils.loadFromFileOrZooKeeper((String)"/depotnearby/config/alipay_config.properties", (String)"/alipay_config.properties");
    private static final String CONFIG_PATH = "/alipay_config.properties";
    private static final String CONF_KEY_NOTIFY_URL = "notify.url";
    private static final String CONF_KEY_RETURN_URL = "return.url";
    private static final String CONF_NOPWD_REFUND_NOTIFY_URL = "notify.nopwd.refund.url";
    private static final String CONF_WAP_SHOW_URL = "alipay.wap.show.url";
    private static String count = "0000";
    private static String dateValue = "yyyyMMdd";
    private static final String invalidParamChars = "\\s*|\t|\r|\n";

    private AlipayFactory() {
    }

    public static AlipayFactory newInstance() {
        return AlipayFactoryHolder.instance;
    }

    public String getSignedMobilePayRequestParams(String appId, String orderPaymentId, String orderSubject, int payAmount, Date payLimitTime) throws UnsupportedEncodingException {
        Map<String, String> sParaTmp = this.buildRequestParams(appId, orderPaymentId, orderSubject, payAmount, payLimitTime);
        Map<String, String> sPara = AlipayCore.paraFilter(sParaTmp);
        String content = AlipayCore.createLinkString(sPara);
        String mySign = RSA.sign(content, AlipayConfig.newInstance().getPrivateKey(appId), AlipayConfig.input_charset);
        mySign = URLEncoder.encode(mySign, AlipayConfig.input_charset);
        sPara.put("sign", mySign);
        sPara.put("sign_type", AlipayConfig.sign_type);
        return AlipayFactory.mapToUrlParams(sPara);
    }

    protected Map<String, String> buildRequestParams(String appId, String orderPaymentId, String orderSubject, int payAmount, Date payLimitTime) {
        String payment_type = "1";
        String notify_url = this.conf.getProperty(CONF_KEY_NOTIFY_URL);
        String out_trade_no = orderPaymentId;
        String subject = orderSubject;
        String total_fee = StringTool.formatPriceToYuanWithFen(payAmount);
        String it_b_pay = payLimitTime == null ? null : DateTool.getMinuteItBPay(payLimitTime.getTime());
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "mobile.securitypay.pay");
        sParaTemp.put("partner", AlipayConfig.newInstance().getPartner(appId));
        sParaTemp.put("seller_id", AlipayConfig.newInstance().getSellerId(appId));
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        sParaTemp.put("payment_type", payment_type);
        sParaTemp.put("notify_url", notify_url);
        sParaTemp.put("out_trade_no", out_trade_no);
        sParaTemp.put("subject", subject);
        sParaTemp.put("total_fee", total_fee);
        sParaTemp.put("it_b_pay", it_b_pay);
        return sParaTemp;
    }

    public static String mapToUrlParams(Map<String, String> sPara) {
        if (sPara == null || sPara.size() == 0) {
            return null;
        }
        ArrayList<String> keys = new ArrayList<String>(sPara.keySet());
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < keys.size(); ++i) {
            String name = (String)keys.get(i);
            String value = sPara.get(name);
            sb.append(name + "=" + value + "&");
        }
        sb.delete(sb.length() - 1, sb.length());
        return sb.toString();
    }

    public String getNotifyUrl() {
        return this.conf.getProperty(CONF_KEY_NOTIFY_URL);
    }

    public String getReturnUrl() {
        return this.conf.getProperty(CONF_KEY_RETURN_URL);
    }

    public String getNotifyUrl(String service) {
        if (StringUtils.isBlank((String)service)) {
            return null;
        }
        if (StringUtils.equals((String)"refund_fastpay_by_platform_nopwd", (String)service)) {
            return this.conf.getProperty(CONF_NOPWD_REFUND_NOTIFY_URL);
        }
        return this.conf.getProperty(CONF_KEY_NOTIFY_URL);
    }

    public String buildWapPayForm(String appId, String orderPaymentId, String orderSubject, String description, int payAmount, Date payLimitTime, String show_url) throws CommonException {
        String payment_type = "1";
        String notify_url = AlipayFactory.newInstance().getNotifyUrl();
        String out_trade_no = orderPaymentId;
        String subject = this.filterInvalidChars(orderSubject);
        String total_fee = StringTool.formatPriceToYuanWithFen(payAmount);
        String body = this.filterInvalidChars(description);
        String it_b_pay = payLimitTime == null ? "" : DateTool.getMinuteItBPay(payLimitTime.getTime());
        HashMap<String, String> sParaTemp = new HashMap<String, String>();
        sParaTemp.put("service", "alipay.wap.create.direct.pay.by.user");
        sParaTemp.put("partner", AlipayConfig.newInstance().getPartner(appId));
        sParaTemp.put("seller_id", AlipayConfig.newInstance().getSellerId(appId));
        sParaTemp.put("_input_charset", AlipayConfig.input_charset);
        sParaTemp.put("payment_type", payment_type);
        sParaTemp.put("notify_url", notify_url);
        sParaTemp.put("return_url", AlipayFactory.newInstance().getReturnUrl());
        sParaTemp.put("out_trade_no", out_trade_no);
        sParaTemp.put("subject", subject);
        sParaTemp.put("total_fee", total_fee);
        sParaTemp.put("show_url", show_url);
        sParaTemp.put("body", body);
        sParaTemp.put("it_b_pay", it_b_pay);
        String sHtmlText = AlipaySubmit.buildRequest(sParaTemp, "POST", "\u786e\u8ba4");
        return sHtmlText;
    }

    protected String filterInvalidChars(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return null;
        }
        String content = new String(str);
        Pattern p = Pattern.compile(invalidParamChars);
        Matcher m = p.matcher(content);
        String result = m.replaceAll("");
        return result;
    }

    private static class AlipayFactoryHolder {
        static AlipayFactory instance = new AlipayFactory();

        private AlipayFactoryHolder() {
        }
    }
}

