/*
 * Decompiled with CFR 0.152.
 */
package com.depotnearby.bean;

import java.io.Serializable;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;

public class PageControl
implements Serializable {
    private static int PAGESIZE = 50;
    private int pageSize = PAGESIZE;
    private int pageCount = 0;
    private int count = 0;
    private int currentPage = 1;
    private int begin = 0;
    private int end = 0;
    private List list = null;
    private String appendParams = "";
    private int currentSkip = 1;
    private int skipSize = 5;

    public PageControl() {
    }

    public PageControl(int defaultPageSize) {
        this.pageSize = defaultPageSize;
    }

    public PageControl(int defaultPageSize, int page) {
        this.pageSize = defaultPageSize;
        this.currentPage = page;
    }

    public PageControl(HttpServletRequest request) {
        this.init(request);
    }

    public PageControl(HttpServletRequest request, int defaultPageSize) {
        this.pageSize = defaultPageSize;
        this.init(request);
    }

    public PageControl(HttpServletRequest request, int defaultPageSize, int page) {
        this.pageSize = defaultPageSize;
        this.currentPage = page;
        this.init(request);
    }

    protected void init(HttpServletRequest request) {
        this.currentPage = 1;
        String page = request.getParameter("page");
        String s_pageSize = request.getParameter("pageSize");
        if (page != null) {
            try {
                this.currentPage = Integer.valueOf(page);
                if (this.currentPage <= 0) {
                    this.currentPage = 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (s_pageSize != null) {
            try {
                if (Integer.valueOf(s_pageSize) > 0) {
                    this.pageSize = Integer.valueOf(s_pageSize);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            this.appendParams = request.getQueryString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.appendParams != null) {
            this.appendParams = this.appendParams.replaceAll("page=" + this.getCurrentPage(), "");
            this.appendParams = this.appendParams.replaceAll("&pageSize=" + this.getPageSize(), "");
            this.appendParams = this.appendParams.replaceAll("&pageSize=" + this.getPageSize(), "");
            this.appendParams = this.appendParams.replaceAll("[&]+", "&");
            this.appendParams = StringUtils.removeEnd((String)this.appendParams, (String)"&");
        } else {
            this.appendParams = "";
        }
        request.setAttribute("pageControl", (Object)this);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageCount() {
        return this.pageCount;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setBegin(int begin) {
        this.begin = begin;
    }

    public int getCount() {
        return this.count;
    }

    public int getBegin() {
        return this.begin;
    }

    public int getEnd() {
        return this.end;
    }

    public List getList() {
        return this.list;
    }

    public String getAppendParams() {
        return this.appendParams;
    }

    public void setCount(int totalCount) {
        if (totalCount <= 0) {
            return;
        }
        this.count = totalCount;
        this.pageCount = totalCount / this.pageSize + (totalCount % this.pageSize == 0 ? 0 : 1);
        if (this.currentPage > this.pageCount) {
            this.currentPage = this.pageCount;
        }
        if (this.currentPage <= 0) {
            this.currentPage = 1;
        }
        this.begin = (this.currentPage - 1) * this.pageSize;
        this.end = this.currentPage * this.pageSize;
        if (this.end >= totalCount) {
            this.end = totalCount;
        }
        this.currentSkip = this.currentPage / this.skipSize * this.skipSize + 1;
        if (this.currentPage % this.skipSize == 0) {
            this.currentSkip -= this.skipSize;
        }
    }

    public boolean getCanGoFirst() {
        return this.currentPage > 1;
    }

    public boolean getCanGoPrevious() {
        return this.currentPage > 1;
    }

    public boolean getCanGoNext() {
        return this.currentPage < this.pageCount;
    }

    public boolean getCanGoLast() {
        return this.currentPage < this.pageCount;
    }

    public int getPrevious() {
        if (this.currentPage > 1) {
            return this.currentPage - 1;
        }
        return 1;
    }

    public int getNext() {
        if (this.currentPage < this.pageCount) {
            return this.currentPage + 1;
        }
        return this.pageCount;
    }

    public void setAll(List objectList) {
        if (objectList != null) {
            this.setCount(objectList.size());
            this.list = objectList.subList(this.getBegin(), this.getEnd());
        } else {
            this.setCount(0);
        }
    }

    public void setList(List list) {
        this.list = list;
    }

    public void setAppendParams(String appendParams) {
        this.appendParams = appendParams;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public boolean getCanSkipPrevious() {
        return this.getSkipPrevious() > 0;
    }

    public int getSkipPrevious() {
        return this.currentSkip - this.skipSize;
    }

    public boolean getCanSkipNext() {
        return this.getSkipNext() <= this.pageCount;
    }

    public int getSkipNext() {
        return this.currentSkip + this.skipSize;
    }

    public int[] getCurrentSkipPageNumbers() {
        int count = this.skipSize;
        if (this.currentSkip + this.skipSize > this.pageCount) {
            count = this.pageCount - this.currentSkip + 1;
        }
        int[] Result = new int[count];
        for (int i = 0; i < count; ++i) {
            Result[i] = this.currentSkip + i;
        }
        return Result;
    }

    public void reCount(int page, int count) {
        this.currentPage = page;
        this.setCount(count);
    }
}

